/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.jdbc.driver.json.JakartaGeneratorWrapper;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonArrayImpl;
import oracle.jdbc.driver.json.binary.OsonContext;

public class JakartaOsonArray
extends OsonAbstractArray
implements JsonArray,
Wrapper {
    public JakartaOsonArray(OsonContext osonContext, int n2) {
        super(osonContext, n2);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(new OsonArrayImpl(new OsonContext(this.ctx), this.pos));
        }
        catch (ClassCastException classCastException) {
            throw new SQLException(classCastException.getMessage(), classCastException);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(OsonArrayImpl.class);
    }

    public JsonObject getJsonObject(int n2) {
        return (JsonObject)this.getJsonObjectInternal(this.getOffsetWithError(n2));
    }

    public JsonArray getJsonArray(int n2) {
        return (JsonArray)this.getArrayInternal(this.getOffsetWithError(n2));
    }

    public JsonNumber getJsonNumber(int n2) {
        return (JsonNumber)this.getValueInternal(this.getOffsetWithError(n2));
    }

    public JsonString getJsonString(int n2) {
        return (JsonString)this.get(n2);
    }

    @Override
    public String getString(int n2) {
        return this.getJsonString(n2).getString();
    }

    public String getString(int n2, String string) {
        if (n2 < 0 || n2 >= this.size()) {
            return string;
        }
        JsonValue jsonValue = this.get(n2);
        if (jsonValue.getValueType() != JsonValue.ValueType.STRING) {
            return string;
        }
        return ((JsonString)jsonValue).getString();
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    public Iterator<JsonValue> iterator() {
        return new OsonAbstractArray.ValueIter<JsonValue>(this);
    }

    public boolean add(JsonValue jsonValue) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends JsonValue> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n2, Collection<? extends JsonValue> collection) {
        throw new UnsupportedOperationException();
    }

    public JsonValue get(int n2) {
        return (JsonValue)this.getInternal(n2);
    }

    public JsonValue set(int n2, JsonValue jsonValue) {
        throw new UnsupportedOperationException();
    }

    public void add(int n2, JsonValue jsonValue) {
        throw new UnsupportedOperationException();
    }

    public JsonValue remove(int n2) {
        throw new UnsupportedOperationException();
    }

    public ListIterator<JsonValue> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<JsonValue> listIterator(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new OsonAbstractArray.ListIter<JsonValue>(this, n2);
    }

    public List<JsonValue> subList(int n2, int n3) {
        return super.sublist(n2, n3);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JakartaGeneratorWrapper jakartaGeneratorWrapper = new JakartaGeneratorWrapper(new JsonSerializerImpl(stringWriter));
        jakartaGeneratorWrapper.write((JsonValue)this);
        jakartaGeneratorWrapper.close();
        return stringWriter.toString();
    }
}

