/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CCallableStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CDriverExtension
extends OracleDriverExtension
implements Monitor {
    private OracleDriverExtension shardingDriverExtension = null;
    private static String shardingDriverExtensionClassName = "oracle.jdbc.driver.ShardingDriverExtension";
    private static final Monitor DEFAULT_CONN_MONITOR = Monitor.newInstance();
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();

    T4CDriverExtension() {
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    final Connection getConnection(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        T4CConnection t4CConnection = new T4CConnection(string, properties, this);
        if (t4CConnection.useShardingDriverConnection() && !t4CConnection.isShardingDriverMode()) {
            if (this.shardingDriverExtension == null) {
                try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                    if (this.shardingDriverExtension == null) {
                        this.shardingDriverExtension = (OracleDriverExtension)Class.forName(shardingDriverExtensionClassName).newInstance();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.shardingDriverExtension.getConnection(string, properties, abstractConnectionBuilder);
        }
        t4CConnection.connect(abstractConnectionBuilder);
        return t4CConnection;
    }

    @Override
    final CompletionStage<Connection> getConnectionAsync(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        try {
            T4CConnection t4CConnection = new T4CConnection(string, properties, this);
            return t4CConnection.connectAsync(abstractConnectionBuilder).thenApply(void_ -> t4CConnection);
        }
        catch (SQLException sQLException) {
            return CompletionStageUtil.failedStage(sQLException);
        }
    }

    @Override
    oracle.jdbc.internal.OracleStatement allocateStatement(OracleConnection oracleConnection, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return new T4CStatement((PhysicalConnection)oracleConnection, properties);
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return new T4CPreparedStatement((PhysicalConnection)oracleConnection, string, properties);
    }

    @Override
    OracleCallableStatement allocateCallableStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return new T4CCallableStatement((PhysicalConnection)oracleConnection, string, properties);
    }

    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        return new T4CInputStream(oracleStatement, n2, accessor);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

