/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public final class UnpickleContext {
    byte[] image;
    int absoluteOffset;
    int beginOffset;
    int markedOffset;
    Vector patches;
    long[] ldsOffsets;
    boolean[] nullIndicators;
    boolean bigEndian;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    public UnpickleContext() {
    }

    public UnpickleContext(byte[] byArray, int n2, boolean[] blArray, long[] lArray, boolean bl) {
        this.image = byArray;
        this.beginOffset = n2;
        this.absoluteOffset = n2;
        this.bigEndian = bl;
        this.nullIndicators = blArray;
        this.patches = null;
        this.ldsOffsets = lArray;
    }

    public byte readByte() throws SQLException {
        try {
            byte by = this.image[this.absoluteOffset];
            return by;
        }
        finally {
            ++this.absoluteOffset;
        }
    }

    public byte[] readVarNumBytes() throws SQLException {
        byte[] byArray = new byte[this.image[this.absoluteOffset] & 0xFF];
        try {
            System.arraycopy(this.image, this.absoluteOffset + 1, byArray, 0, byArray.length);
        }
        finally {
            this.absoluteOffset += 22;
        }
        return byArray;
    }

    public byte[] readPtrBytes() throws SQLException {
        byte[] byArray = new byte[(this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2];
        System.arraycopy(this.image, this.absoluteOffset, byArray, 0, byArray.length);
        this.absoluteOffset += byArray.length;
        return byArray;
    }

    public void skipPtrBytes() throws SQLException {
        this.absoluteOffset += (this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.image, this.absoluteOffset, byArray, 0, n2);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            this.absoluteOffset += n2;
        }
    }

    public long readLong() throws SQLException {
        try {
            long l2 = (((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 2] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 3] & 0xFF);
            return l2;
        }
        finally {
            this.absoluteOffset += 4;
        }
    }

    public short readShort() throws SQLException {
        try {
            short s2 = (short)((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF));
            return s2;
        }
        finally {
            this.absoluteOffset += 2;
        }
    }

    public byte[] readLengthBytes() throws SQLException {
        long l2 = this.readLong();
        return this.readBytes((int)l2);
    }

    public void skipLengthBytes() throws SQLException {
        long l2 = this.readLong();
        this.absoluteOffset = (int)((long)this.absoluteOffset + l2);
    }

    public void skipTo(long l2) throws SQLException {
        if (l2 > (long)(this.absoluteOffset - this.beginOffset)) {
            this.absoluteOffset = this.beginOffset + (int)l2;
        }
    }

    public void skipTo(int n2) throws SQLException {
        if (n2 > this.absoluteOffset - this.beginOffset) {
            this.absoluteOffset = this.beginOffset + n2;
        }
    }

    public void mark() throws SQLException {
        this.markedOffset = this.absoluteOffset;
    }

    public void reset() throws SQLException {
        this.absoluteOffset = this.markedOffset;
    }

    public void markAndSkip() throws SQLException {
        this.markedOffset = this.absoluteOffset + 4;
        this.absoluteOffset = this.beginOffset + (int)this.readLong();
    }

    public void markAndSkip(long l2) throws SQLException {
        this.markedOffset = this.absoluteOffset;
        this.absoluteOffset = this.beginOffset + (int)l2;
    }

    public void skipBytes(int n2) throws SQLException {
        if (n2 >= 0) {
            this.absoluteOffset += n2;
        }
    }

    public boolean isNull(int n2) {
        return this.nullIndicators[n2];
    }

    public int absoluteOffset() throws SQLException {
        return this.absoluteOffset;
    }

    public int offset() throws SQLException {
        return this.absoluteOffset - this.beginOffset;
    }

    public byte[] image() throws SQLException {
        return this.image;
    }

    static {
        try {
            $$$methodRef$$$21 = UnpickleContext.class.getDeclaredConstructor(byte[].class, Integer.TYPE, boolean[].class, long[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = UnpickleContext.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = UnpickleContext.class.getDeclaredMethod("image", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = UnpickleContext.class.getDeclaredMethod("offset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = UnpickleContext.class.getDeclaredMethod("absoluteOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = UnpickleContext.class.getDeclaredMethod("isNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = UnpickleContext.class.getDeclaredMethod("skipBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = UnpickleContext.class.getDeclaredMethod("markAndSkip", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = UnpickleContext.class.getDeclaredMethod("markAndSkip", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = UnpickleContext.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = UnpickleContext.class.getDeclaredMethod("mark", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = UnpickleContext.class.getDeclaredMethod("skipTo", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = UnpickleContext.class.getDeclaredMethod("skipTo", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = UnpickleContext.class.getDeclaredMethod("skipLengthBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = UnpickleContext.class.getDeclaredMethod("readLengthBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = UnpickleContext.class.getDeclaredMethod("readShort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = UnpickleContext.class.getDeclaredMethod("readLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = UnpickleContext.class.getDeclaredMethod("readBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = UnpickleContext.class.getDeclaredMethod("skipPtrBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = UnpickleContext.class.getDeclaredMethod("readPtrBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = UnpickleContext.class.getDeclaredMethod("readVarNumBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = UnpickleContext.class.getDeclaredMethod("readByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

