/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;

public final class OracleType
extends Enum<OracleType>
implements SQLType {
    public static final /* enum */ OracleType VARCHAR2;
    public static final /* enum */ OracleType NVARCHAR;
    public static final /* enum */ OracleType NUMBER;
    public static final /* enum */ OracleType FLOAT;
    public static final /* enum */ OracleType LONG;
    public static final /* enum */ OracleType DATE;
    public static final /* enum */ OracleType BINARY_FLOAT;
    public static final /* enum */ OracleType BINARY_DOUBLE;
    public static final /* enum */ OracleType TIMESTAMP;
    public static final /* enum */ OracleType TIMESTAMP_WITH_TIME_ZONE;
    public static final /* enum */ OracleType TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    public static final /* enum */ OracleType INTERVAL_YEAR_TO_MONTH;
    public static final /* enum */ OracleType INTERVAL_DAY_TO_SECOND;
    public static final /* enum */ OracleType PLSQL_BOOLEAN;
    public static final /* enum */ OracleType RAW;
    public static final /* enum */ OracleType LONG_RAW;
    public static final /* enum */ OracleType ROWID;
    public static final /* enum */ OracleType UROWID;
    public static final /* enum */ OracleType CHAR;
    public static final /* enum */ OracleType NCHAR;
    public static final /* enum */ OracleType CLOB;
    public static final /* enum */ OracleType NCLOB;
    public static final /* enum */ OracleType BLOB;
    public static final /* enum */ OracleType BFILE;
    public static final /* enum */ OracleType OBJECT;
    public static final /* enum */ OracleType REF;
    public static final /* enum */ OracleType VARRAY;
    public static final /* enum */ OracleType NESTED_TABLE;
    public static final /* enum */ OracleType ANYTYPE;
    public static final /* enum */ OracleType ANYDATA;
    public static final /* enum */ OracleType ANYDATASET;
    public static final /* enum */ OracleType XMLTYPE;
    public static final /* enum */ OracleType HTTPURITYPE;
    public static final /* enum */ OracleType XDBURITYPE;
    public static final /* enum */ OracleType DBURITYPE;
    public static final /* enum */ OracleType SDO_GEOMETRY;
    public static final /* enum */ OracleType SDO_TOPO_GEOMETRY;
    public static final /* enum */ OracleType SDO_GEORASTER;
    public static final /* enum */ OracleType ORDAUDIO;
    public static final /* enum */ OracleType ORDDICOM;
    public static final /* enum */ OracleType ORDDOC;
    public static final /* enum */ OracleType ORDIMAGE;
    public static final /* enum */ OracleType ORDVIDEO;
    public static final /* enum */ OracleType SI_AVERAGE_COLOR;
    public static final /* enum */ OracleType SI_COLOR;
    public static final /* enum */ OracleType SI_COLOR_HISTOGRAM;
    public static final /* enum */ OracleType SI_FEATURE_LIST;
    public static final /* enum */ OracleType SI_POSITIONAL_COLOR;
    public static final /* enum */ OracleType SI_STILL_IMAGE;
    public static final /* enum */ OracleType SI_TEXTURE;
    private final boolean isSupported;
    private final String typeName;
    private final int code;
    private final boolean isNationalCharacterSet;
    private static final /* synthetic */ OracleType[] $VALUES;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public static OracleType[] values() {
        return (OracleType[])$VALUES.clone();
    }

    public static OracleType valueOf(String string) {
        return Enum.valueOf(OracleType.class, string);
    }

    public static OracleType toOracleType(SQLType sQLType) throws SQLException {
        if (sQLType instanceof OracleType) {
            return (OracleType)sQLType;
        }
        return null;
    }

    public static OracleType toOracleType(int n2) throws SQLException {
        List<OracleType> list = Arrays.asList(OracleType.values());
        OracleType oracleType = null;
        for (OracleType oracleType2 : list) {
            if (oracleType2.getVendorTypeNumber() != n2) continue;
            oracleType = oracleType2;
            break;
        }
        return oracleType;
    }

    private OracleType(String string2) {
        this.isSupported = false;
        this.typeName = string2;
        this.code = Integer.MIN_VALUE;
        this.isNationalCharacterSet = false;
    }

    private OracleType(String string2, int n3) {
        this.isSupported = true;
        this.typeName = string2;
        this.code = n3;
        this.isNationalCharacterSet = false;
    }

    private OracleType(String string2, int n3, boolean bl) {
        this.isSupported = true;
        this.typeName = string2;
        this.code = n3;
        this.isNationalCharacterSet = bl;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public String getVendor() {
        return "Oracle Database";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.code;
    }

    public boolean isNationalCharacterSet() {
        return this.isNationalCharacterSet;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    private OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$12 = OracleType.class.getDeclaredConstructor(String.class, Integer.TYPE, String.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleType.class.getDeclaredConstructor(String.class, Integer.TYPE, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleType.class.getDeclaredConstructor(String.class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleType.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleType.class.getDeclaredMethod("isSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleType.class.getDeclaredMethod("isNationalCharacterSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleType.class.getDeclaredMethod("getVendorTypeNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleType.class.getDeclaredMethod("getVendor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleType.class.getDeclaredMethod("getName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleType.class.getDeclaredMethod("toOracleType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleType.class.getDeclaredMethod("toOracleType", SQLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleType.class.getDeclaredMethod("valueOf", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleType.class.getDeclaredMethod("values", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        VARCHAR2 = new OracleType("VARCHAR2", 12);
        NVARCHAR = new OracleType("NVARCHAR", -9, true);
        NUMBER = new OracleType("NUMBER", 2);
        FLOAT = new OracleType("FLOAT", 6);
        LONG = new OracleType("LONG", -1);
        DATE = new OracleType("DATE", 91);
        BINARY_FLOAT = new OracleType("BINARY FLOAT", 100);
        BINARY_DOUBLE = new OracleType("BINARY DOUBLE", 101);
        TIMESTAMP = new OracleType("TIMESTAMP", 93);
        TIMESTAMP_WITH_TIME_ZONE = new OracleType("TIMESTAMP WITH TIME ZONE", -101);
        TIMESTAMP_WITH_LOCAL_TIME_ZONE = new OracleType("TIMESTAMP WITH LOCAL TIME ZONE", -102);
        INTERVAL_YEAR_TO_MONTH = new OracleType("INTERVAL YEAR TO MONTH", -103);
        INTERVAL_DAY_TO_SECOND = new OracleType("INTERVAL DAY TO SECOND", -104);
        PLSQL_BOOLEAN = new OracleType("PLSQL_BOOLEAN", 252);
        RAW = new OracleType("RAW", -2);
        LONG_RAW = new OracleType("LONG RAW", -4);
        ROWID = new OracleType("ROWID", -8);
        UROWID = new OracleType("UROWID");
        CHAR = new OracleType("CHAR", 1);
        NCHAR = new OracleType("NCHAR", -15, true);
        CLOB = new OracleType("CLOB", 2005);
        NCLOB = new OracleType("NCLOB", 2011, true);
        BLOB = new OracleType("BLOB", 2004);
        BFILE = new OracleType("BFILE", -13);
        OBJECT = new OracleType("OBJECT", 2002);
        REF = new OracleType("REF", 2006);
        VARRAY = new OracleType("VARRAY", 2003);
        NESTED_TABLE = new OracleType("NESTED_TABLE", 2003);
        ANYTYPE = new OracleType("ANYTYPE", 2007);
        ANYDATA = new OracleType("ANYDATA", 2007);
        ANYDATASET = new OracleType("ANYDATASET");
        XMLTYPE = new OracleType("XMLTYPE", 2009);
        HTTPURITYPE = new OracleType("HTTPURITYPE");
        XDBURITYPE = new OracleType("XDBURITYPE");
        DBURITYPE = new OracleType("DBURITYPE");
        SDO_GEOMETRY = new OracleType("SDO_GEOMETRY");
        SDO_TOPO_GEOMETRY = new OracleType("SDO_TOPO_GEOMETRY");
        SDO_GEORASTER = new OracleType("SDO_GEORASTER");
        ORDAUDIO = new OracleType("ORDAUDIO");
        ORDDICOM = new OracleType("ORDDICOM");
        ORDDOC = new OracleType("ORDDOC");
        ORDIMAGE = new OracleType("ORDIMAGE");
        ORDVIDEO = new OracleType("ORDVIDEO");
        SI_AVERAGE_COLOR = new OracleType("SI_AVERAGE_COLOR");
        SI_COLOR = new OracleType("SI_COLOR");
        SI_COLOR_HISTOGRAM = new OracleType("SI_COLOR_HISTOGRAM");
        SI_FEATURE_LIST = new OracleType("SI_FEATURE_LIST");
        SI_POSITIONAL_COLOR = new OracleType("SI_POSITIONAL_COLOR");
        SI_STILL_IMAGE = new OracleType("SI_STILL_IMAGE");
        SI_TEXTURE = new OracleType("SI_TEXTURE");
        $VALUES = new OracleType[]{VARCHAR2, NVARCHAR, NUMBER, FLOAT, LONG, DATE, BINARY_FLOAT, BINARY_DOUBLE, TIMESTAMP, TIMESTAMP_WITH_TIME_ZONE, TIMESTAMP_WITH_LOCAL_TIME_ZONE, INTERVAL_YEAR_TO_MONTH, INTERVAL_DAY_TO_SECOND, PLSQL_BOOLEAN, RAW, LONG_RAW, ROWID, UROWID, CHAR, NCHAR, CLOB, NCLOB, BLOB, BFILE, OBJECT, REF, VARRAY, NESTED_TABLE, ANYTYPE, ANYDATA, ANYDATASET, XMLTYPE, HTTPURITYPE, XDBURITYPE, DBURITYPE, SDO_GEOMETRY, SDO_TOPO_GEOMETRY, SDO_GEORASTER, ORDAUDIO, ORDDICOM, ORDDOC, ORDIMAGE, ORDVIDEO, SI_AVERAGE_COLOR, SI_COLOR, SI_COLOR_HISTOGRAM, SI_FEATURE_LIST, SI_POSITIONAL_COLOR, SI_STILL_IMAGE, SI_TEXTURE};
    }
}

