/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIrxd
extends T4CTTIMsg {
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    int rowCount = 0;
    static final byte TTICMD_UNAUTHORIZED = 1;
    private int[] indicesOfColumnsToBeCopied = null;
    static int call_count = 0;

    T4CTTIrxd(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)7);
    }

    void init() {
        this.rowCount = 0;
    }

    void setNumberOfColumns(int n2) {
        this.nbOfColumns = n2;
        this.bvcFound = false;
        if (this.bvcColSent == null || this.bvcColSent.length() < this.nbOfColumns) {
            this.bvcColSent = new BitSet(this.nbOfColumns);
        } else {
            this.bvcColSent.clear();
        }
    }

    void unmarshalBVC(int n2) throws SQLException, IOException {
        this.bvcColSent.clear();
        int n3 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = (byte)(this.meg.unmarshalUB1() & 0xFF);
            this.bvcColSent.set(i2, by);
        }
        this.bvcFound = true;
    }

    void readBitVector(byte[] byArray, int n2) throws SQLException, IOException {
        this.bvcColSent.clear();
        if (n2 == 0) {
            this.bvcFound = false;
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by = byArray[i2];
                this.bvcColSent.set(i2, by);
            }
            this.bvcFound = true;
        }
    }

    Vector<IOException> marshal(byte[] byArray, char[] cArray, short[] sArray, int n2, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[] byArray3, char[] cArray2, short[] sArray2, byte[] byArray4, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2, ByteArray byteArray, long[] lArray, int[] nArray5, boolean bl3) throws IOException {
        if (bl3) {
            return this.marshalBindDBA(sArray, n2, inputStreamArray, byArray3, cArray2, sArray2, byArray4, n3, nArray, bl, nArray2, nArray3, nArray4, bl2, byteArray, lArray, nArray5);
        }
        return this.marshalPrimitive(byArray, cArray, sArray, n2, byArray2, dBConversion, inputStreamArray, byArray3, cArray2, sArray2, byArray4, n3, nArray, bl, nArray2, nArray3, nArray4, bl2);
    }

    Vector<IOException> marshalBindDBA(short[] sArray, int n2, InputStream[] inputStreamArray, byte[] byArray, char[] cArray, short[] sArray2, byte[] byArray2, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2, ByteArray byteArray, long[] lArray, int[] nArray5) throws IOException {
        Vector<IOException> vector = null;
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int[] nArray6;
            int n12;
            int n13;
            block49: {
                int n14;
                int n15;
                block48: {
                    this.marshalTTCcode();
                    n13 = sArray[n2 + 0] & 0xFFFF;
                    n15 = 0;
                    n12 = nArray3[0];
                    nArray6 = nArray4[0];
                    n14 = 0;
                    if (!bl2) break block48;
                    n11 = 1;
                    assert (n12 > 0) : "No postoned columns in RXD";
                    break block49;
                }
                for (n10 = 0; n10 < n13; ++n10) {
                    byte[] byArray3;
                    int n16;
                    int n17;
                    block50: {
                        block52: {
                            block51: {
                                if (n15 < n12 && nArray6[n15] == n10) {
                                    ++n15;
                                    continue;
                                }
                                n9 = 0;
                                n8 = n2 + 5 + 10 * n10;
                                n7 = sArray[n8 + 0] & 0xFFFF;
                                if (byArray2 != null && (byArray2[n10] & 0x20) == 0) {
                                    if (n7 != 998) continue;
                                    ++n14;
                                    continue;
                                }
                                int n18 = ((sArray[n8 + 7] & 0xFFFF) << 16) + (sArray[n8 + 8] & 0xFFFF) + n3;
                                n6 = ((sArray[n8 + 5] & 0xFFFF) << 16) + (sArray[n8 + 6] & 0xFFFF) + n3;
                                n17 = sArray[n18] & 0xFFFF;
                                n5 = sArray[n6];
                                if (n7 == 116) {
                                    this.meg.marshalUB1((short)1);
                                    this.meg.marshalUB1((short)0);
                                    continue;
                                }
                                if (n7 == 102) {
                                    n4 = n3 * n13 + n10;
                                    n16 = nArray5[n4];
                                    if (n16 == 0) {
                                        this.meg.marshalUB1((short)1);
                                        this.meg.marshalUB1((short)0);
                                        continue;
                                    }
                                    byArray3 = new byte[n16];
                                    byteArray.get(lArray[n4], byArray3, 0, n16);
                                    int n19 = byArray3[0] << 24 | byArray3[1] << 16 | byArray3[2] << 8 | byArray3[3];
                                    int n20 = n19 == 0 ? 0 : (n19 <= 255 ? 1 : (n19 <= 65535 ? 2 : (n19 <= 0xFFFFFF ? 3 : 4)));
                                    this.meg.marshalUB1((short)(n20 + 1));
                                    this.meg.marshalUB4(n19);
                                    continue;
                                }
                                if (n7 == 994) {
                                    n5 = -1;
                                    n4 = nArray2[3 + n10 * 4 + 0];
                                    if (n4 == 109) {
                                        n9 = 1;
                                    }
                                } else if (n7 == 8 || n7 == 24 || !bl && nArray != null && nArray.length > n10 && nArray[n10] > this.connection.maxNonStreamBindByteSize) {
                                    if (n12 >= nArray6.length) {
                                        int[] nArray7 = new int[nArray6.length << 1];
                                        System.arraycopy(nArray6, 0, nArray7, 0, nArray6.length);
                                        nArray6 = nArray7;
                                    }
                                    nArray6[n12++] = n10;
                                    continue;
                                }
                                if (n5 != -1) break block50;
                                if (n7 == 109) break block51;
                                if (n9 == 0) break block52;
                            }
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (n7 == 998) {
                            ++n14;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n7 == 112 || n7 == 113 || n7 == 114) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n7 != 8 && n7 != 24) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (n7 == 998) {
                        n4 = (sArray2[6 + n14 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF0000 | sArray2[6 + n14 * 8 + 5] & 0xFFFF;
                        n16 = (sArray2[6 + n14 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF0000 | sArray2[6 + n14 * 8 + 7] & 0xFFFF;
                        int n21 = sArray2[6 + n14 * 8] & 0xFFFF;
                        int n22 = sArray2[6 + n14 * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(n4);
                        byte[] byArray4 = null;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            int n23 = n16 + i2 * n22;
                            if (n21 == 9) {
                                int n24 = cArray[n23] / 2;
                                if (byArray4 == null) {
                                    byArray4 = this.connection.getByteBuffer(n24 * 4);
                                } else if (byArray4.length < n24 * 4) {
                                    this.connection.cacheBuffer(byArray4);
                                    byArray4 = this.connection.getByteBuffer(n24 * 4);
                                }
                                int n25 = this.connection.conversion.javaCharsToCHARBytes(cArray, n23 + 1, byArray4, 0, n24);
                                this.meg.marshalCLR(byArray4, n25);
                                continue;
                            }
                            n17 = byArray[n23];
                            if (n17 < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(byArray, n23 + 1, n17);
                        }
                        this.connection.cacheBuffer(byArray4);
                        ++n14;
                        continue;
                    }
                    int n26 = sArray[n8 + 1] & 0xFFFF;
                    if (n26 != 0) {
                        if (n7 == 6) {
                            --n17;
                        } else if (n7 == 9) {
                            n17 -= 2;
                        } else if (n7 == 114 || n7 == 113 || n7 == 112) {
                            this.meg.marshalUB4(n17);
                        }
                        if (n7 == 109 || n7 == 111) {
                            if (n7 == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(n17);
                                this.meg.marshalUB2(1);
                            }
                            if (n17 <= 0) continue;
                            n4 = n3 * n13 + n10;
                            this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n4], nArray5[n4]);
                            continue;
                        }
                        if (n7 == 104) {
                            n4 = n3 * n13 + n10;
                            n16 = nArray5[n4];
                            byArray3 = new byte[n16];
                            byteArray.get(lArray[n4], byArray3, 0, n16);
                            long[] lArray2 = T4CRowidAccessor.stringToRowid(byArray3, 2, 18);
                            short s2 = 14;
                            long l2 = lArray2[0];
                            int n27 = (int)lArray2[1];
                            short s3 = 0;
                            long l3 = lArray2[2];
                            int n28 = (int)lArray2[3];
                            if (l2 == 0L && n27 == 0 && l3 == 0L && n28 == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1(s2);
                            this.meg.marshalUB4(l2);
                            this.meg.marshalUB2(n27);
                            this.meg.marshalUB1(s3);
                            this.meg.marshalUB4(l3);
                            this.meg.marshalUB2(n28);
                            continue;
                        }
                        if (n7 == 208) {
                            this.meg.marshalUB4(n17 -= 2);
                            n4 = n3 * n13 + n10;
                            this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n4], nArray5[n4]);
                            continue;
                        }
                        if (n17 < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        n4 = n3 * n13 + n10;
                        this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n4], nArray5[n4]);
                        continue;
                    }
                    n4 = n3 * n13 + n10;
                    this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n4], nArray5[n4]);
                }
                n11 = n12;
            }
            if (n12 > 0) {
                for (n10 = 0; n10 < n11; ++n10) {
                    InputStream inputStream;
                    n9 = nArray6[n10];
                    n8 = n2 + 5 + 10 * n9;
                    n7 = sArray[n8 + 0] & 0xFFFF;
                    n6 = ((sArray[n8 + 5] & 0xFFFF) << 16) + (sArray[n8 + 6] & 0xFFFF) + n3;
                    n5 = sArray[n6];
                    if (n5 == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n7 == 996) {
                        n4 = n3 * n13 + n9;
                        this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n4], nArray5[n4]);
                        continue;
                    }
                    if (n7 != 8 && n7 != 24) {
                        n4 = n3 * n13 + n9;
                        this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n4], nArray5[n4]);
                        continue;
                    }
                    n4 = n9;
                    if (inputStreamArray == null || (inputStream = inputStreamArray[n4]) == null) continue;
                    try {
                        this.meg.marshalCLR(inputStream, 0);
                    }
                    catch (IOException iOException) {
                        if (vector == null) {
                            vector = new Vector<IOException>();
                        }
                        vector.add(iOException);
                    }
                }
            }
            nArray3[0] = n12;
            nArray4[0] = nArray6;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException();
            iOException.initCause(sQLException);
            throw iOException;
        }
        return vector;
    }

    Vector<IOException> marshalPrimitive(byte[] byArray, char[] cArray, short[] sArray, int n2, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[] byArray3, char[] cArray2, short[] sArray2, byte[] byArray4, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2) throws IOException {
        Vector<IOException> vector = null;
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int[] nArray5;
            int n18;
            block53: {
                int n19;
                int n20;
                int n21;
                block52: {
                    this.marshalTTCcode();
                    n21 = sArray[n2 + 0] & 0xFFFF;
                    n20 = 0;
                    n18 = nArray3[0];
                    nArray5 = nArray4[0];
                    n19 = 0;
                    if (!bl2) break block52;
                    n17 = 1;
                    assert (n18 > 0) : "No postoned columns in RXD";
                    break block53;
                }
                for (n16 = 0; n16 < n21; ++n16) {
                    short s2;
                    int n22;
                    int n23;
                    int n24;
                    block54: {
                        block56: {
                            block55: {
                                if (n20 < n18 && nArray5[n20] == n16) {
                                    ++n20;
                                    continue;
                                }
                                n15 = 0;
                                n14 = n2 + 5 + 10 * n16;
                                n13 = sArray[n14 + 0] & 0xFFFF;
                                if (byArray4 != null && (byArray4[n16] & 0x20) == 0) {
                                    if (n13 != 998) continue;
                                    ++n19;
                                    continue;
                                }
                                n12 = ((sArray[n14 + 7] & 0xFFFF) << 16) + (sArray[n14 + 8] & 0xFFFF) + n3;
                                n11 = ((sArray[n14 + 5] & 0xFFFF) << 16) + (sArray[n14 + 6] & 0xFFFF) + n3;
                                n10 = sArray[n12] & 0xFFFF;
                                n9 = sArray[n11];
                                if (n13 == 116) {
                                    this.meg.marshalUB1((short)1);
                                    this.meg.marshalUB1((short)0);
                                    continue;
                                }
                                if (n13 == 994) {
                                    n9 = -1;
                                    n24 = nArray2[3 + n16 * 4 + 0];
                                    if (n24 == 109) {
                                        n15 = 1;
                                    }
                                } else if (n13 == 8 || n13 == 24 || !bl && nArray != null && nArray.length > n16 && nArray[n16] > this.connection.maxNonStreamBindByteSize) {
                                    if (n18 >= nArray5.length) {
                                        int[] nArray6 = new int[nArray5.length << 1];
                                        System.arraycopy(nArray5, 0, nArray6, 0, nArray5.length);
                                        nArray5 = nArray6;
                                    }
                                    nArray5[n18++] = n16;
                                    continue;
                                }
                                if (n9 != -1) break block54;
                                if (n13 == 109) break block55;
                                if (n15 == 0) break block56;
                            }
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (n13 == 998) {
                            ++n19;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n13 == 112 || n13 == 113 || n13 == 114) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n13 != 8 && n13 != 24) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (n13 == 998) {
                        n24 = (sArray2[6 + n19 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF0000 | sArray2[6 + n19 * 8 + 5] & 0xFFFF;
                        n23 = (sArray2[6 + n19 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF0000 | sArray2[6 + n19 * 8 + 7] & 0xFFFF;
                        int n25 = sArray2[6 + n19 * 8] & 0xFFFF;
                        int n26 = sArray2[6 + n19 * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(n24);
                        for (n22 = 0; n22 < n24; ++n22) {
                            s2 = n23 + n22 * n26;
                            if (n25 == 9) {
                                n8 = cArray2[s2] / 2;
                                n7 = 0;
                                n7 = dBConversion.javaCharsToCHARBytes(cArray2, s2 + 1, byArray2, 0, n8);
                                this.meg.marshalCLR(byArray2, n7);
                                continue;
                            }
                            n10 = byArray3[s2];
                            if (n10 < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(byArray3, s2 + 1, n10);
                        }
                        ++n19;
                        continue;
                    }
                    int n27 = sArray[n14 + 1] & 0xFFFF;
                    if (n27 != 0) {
                        int n28 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n27 * n3;
                        if (n13 == 6) {
                            ++n28;
                            --n10;
                        } else if (n13 == 9) {
                            n28 += 2;
                            n10 -= 2;
                        } else if (n13 == 114 || n13 == 113 || n13 == 112) {
                            this.meg.marshalUB4(n10);
                        }
                        if (n13 == 109 || n13 == 111) {
                            if (n13 == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(n10);
                                this.meg.marshalUB2(1);
                            }
                            if (n10 <= 0) continue;
                            this.meg.marshalCLR(byArray, n28, n10);
                            continue;
                        }
                        if (n13 == 104) {
                            long[] lArray = T4CRowidAccessor.stringToRowid(byArray, n28 += 2, 18);
                            n23 = 14;
                            long l2 = lArray[0];
                            n22 = (int)lArray[1];
                            s2 = 0;
                            long l3 = lArray[2];
                            int n29 = (int)lArray[3];
                            if (l2 == 0L && n22 == 0 && l3 == 0L && n29 == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1((short)n23);
                            this.meg.marshalUB4(l2);
                            this.meg.marshalUB2(n22);
                            this.meg.marshalUB1(s2);
                            this.meg.marshalUB4(l3);
                            this.meg.marshalUB2(n29);
                            continue;
                        }
                        if (n13 == 208) {
                            this.meg.marshalUB4(n10 -= 2);
                            this.meg.marshalCLR(byArray, n28 += 2, n10);
                            continue;
                        }
                        if (n10 < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        this.meg.marshalCLR(byArray, n28, n10);
                        continue;
                    }
                    n6 = sArray[n14 + 9] & 0xFFFF;
                    n5 = sArray[n14 + 2] & 0xFFFF;
                    n4 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n13 == 996) {
                        n24 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n24) {
                            this.bufferCHAR = new byte[n24];
                        }
                        for (n23 = 0; n23 < n24; ++n23) {
                            this.bufferCHAR[n23] = (byte)((cArray[n4 + n23 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (n23 >= n24 - 1) continue;
                            this.bufferCHAR[n23 + 1] = (byte)(cArray[n4 + n23 / 2] & 0xFF & 0xFF);
                            ++n23;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n24);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n13 == 96) {
                        n8 = n10 / 2;
                        --n4;
                    } else {
                        n8 = (n10 - 2) / 2;
                    }
                    n7 = 0;
                    n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                    this.meg.marshalCLR(byArray2, n7);
                }
                n17 = n18;
            }
            if (n18 > 0) {
                for (n16 = 0; n16 < n17; ++n16) {
                    InputStream inputStream;
                    int n30;
                    n15 = nArray5[n16];
                    n14 = n2 + 5 + 10 * n15;
                    n13 = sArray[n14 + 0] & 0xFFFF;
                    n12 = ((sArray[n14 + 7] & 0xFFFF) << 16) + (sArray[n14 + 8] & 0xFFFF) + n3;
                    n11 = ((sArray[n14 + 5] & 0xFFFF) << 16) + (sArray[n14 + 6] & 0xFFFF) + n3;
                    n9 = sArray[n11];
                    n10 = sArray[n12] & 0xFFFF;
                    n5 = sArray[n14 + 2] & 0xFFFF;
                    n4 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n9 == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n13 == 996) {
                        n30 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n30) {
                            this.bufferCHAR = new byte[n30];
                        }
                        for (int i2 = 0; i2 < n30; ++i2) {
                            this.bufferCHAR[i2] = (byte)((cArray[n4 + i2 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i2 >= n30 - 1) continue;
                            this.bufferCHAR[i2 + 1] = (byte)(cArray[n4 + i2 / 2] & 0xFF & 0xFF);
                            ++i2;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n30);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n13 != 8 && n13 != 24) {
                        if (n13 == 96) {
                            n8 = n10 / 2;
                            --n4;
                        } else {
                            n8 = (n10 - 2) / 2;
                        }
                        n6 = sArray[n14 + 9] & 0xFFFF;
                        n7 = 0;
                        n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                        this.meg.marshalCLR(byArray2, n7);
                        continue;
                    }
                    n30 = n15;
                    if (inputStreamArray == null || (inputStream = inputStreamArray[n30]) == null) continue;
                    try {
                        this.meg.marshalCLR(inputStream, 0);
                    }
                    catch (IOException iOException) {
                        if (vector == null) {
                            vector = new Vector<IOException>();
                        }
                        vector.add(iOException);
                    }
                }
            }
            nArray3[0] = n18;
            nArray4[0] = nArray5;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException();
            iOException.initCause(sQLException);
            throw iOException;
        }
        return vector;
    }

    boolean unmarshal(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        return this.unmarshal(accessorArray, 0, n2);
    }

    void copyRowsAsNeeded(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        if (this.rowCount == 1) {
            this.copyRowsAsNeededByOffset(accessorArray, n2);
        } else {
            int n3 = Math.min(n2, accessorArray.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                Accessor accessor = accessorArray[i2];
                if (accessor.isUseLess || this.bvcColSent.get(accessor.physicalColumnIndex)) continue;
                accessor.copyRow();
            }
        }
    }

    void copyRowsAsNeededByOffset(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        int n3;
        int n4 = Math.min(n2, accessorArray.length);
        for (n3 = 0; n3 < n4; ++n3) {
            Accessor accessor = accessorArray[n3];
            if (!accessor.isUseLess && !this.bvcColSent.get(accessor.physicalColumnIndex)) break;
        }
        if (n3 < n4) {
            Object object;
            if (this.indicesOfColumnsToBeCopied == null || this.indicesOfColumnsToBeCopied.length != this.nbOfColumns) {
                this.indicesOfColumnsToBeCopied = new int[this.nbOfColumns];
            }
            int n5 = 0;
            while (n3 < n4) {
                object = accessorArray[n3];
                if (!((Accessor)object).isUseLess && !this.bvcColSent.get(((Accessor)object).physicalColumnIndex)) {
                    this.indicesOfColumnsToBeCopied[n5++] = n3;
                }
                ++n3;
            }
            object = new MinHeap(accessorArray, this.indicesOfColumnsToBeCopied, n5);
            while (n5 > 0) {
                accessorArray[((MinHeap)object).removeLeast()].copyRow();
                --n5;
            }
        }
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        ++this.rowCount;
        for (n4 = n2; n4 < n3 && n4 < accessorArray.length; ++n4) {
            if (accessorArray[n4] == null || accessorArray[n4].physicalColumnIndex >= 0) continue;
            int n5 = 0;
            for (int i2 = 0; i2 < n3 && i2 < accessorArray.length; ++i2) {
                if (accessorArray[i2] == null) continue;
                accessorArray[i2].physicalColumnIndex = n5++;
                if (accessorArray[i2].isUseLess) continue;
            }
        }
        if (this.bvcFound && n2 == 0) {
            this.copyRowsAsNeeded(accessorArray, n3);
        }
        for (n4 = n2; n4 < n3 && n4 < accessorArray.length; ++n4) {
            block8: {
                block7: {
                    if (accessorArray[n4] == null || this.bvcFound && !accessorArray[n4].isUseLess && !this.bvcColSent.get(accessorArray[n4].physicalColumnIndex)) continue;
                    if (accessorArray[n4].statement.statementType == 2) break block7;
                    if (!accessorArray[n4].statement.sqlKind.isPlsqlOrCall()) break block8;
                }
                accessorArray[n4].setCapacity(1);
            }
            if (!accessorArray[n4].unmarshalOneRow()) continue;
            return true;
        }
        this.bvcFound = false;
        return false;
    }

    String dumpIndicesOfColumnsToBeCopied(int n2, int[] nArray, Accessor[] accessorArray) throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("dump indicesOfColumnsToBeCopied call_count: " + call_count++ + " numColumnsToBeCopied: " + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = accessorArray[nArray[i2]].getOffset(0);
            printWriter.println("copy order: " + i2 + " index: " + nArray[i2] + " offset: " + l2);
        }
        printWriter.println();
        return stringWriter.toString();
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3, int n4) throws SQLException, IOException {
        return false;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static final class BitSet {
        private static final int[] SET_MASK = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        private static final int[] CLEAR_MASK = new int[]{254, 253, 251, 247, 239, 223, 191, 127};
        private final int capacity;
        private final byte[] bits;

        BitSet(int n2) {
            this.bits = new byte[(n2 + 7) / 8];
            this.capacity = this.bits.length * 8;
        }

        final int length() {
            return this.capacity;
        }

        final void set(int n2) {
            int n3 = n2 / 8;
            this.bits[n3] = (byte)(this.bits[n3] | SET_MASK[n2 % 8]);
        }

        final void set(int n2, byte by) {
            this.bits[n2] = by;
        }

        final void clear(int n2) {
            int n3 = n2 / 8;
            this.bits[n3] = (byte)(this.bits[n3] & CLEAR_MASK[n2 % 8]);
        }

        final boolean get(int n2) {
            return (this.bits[n2 / 8] & SET_MASK[n2 % 8]) > 0;
        }

        final void clear() {
            for (int i2 = 0; i2 < this.bits.length; ++i2) {
                this.bits[i2] = 0;
            }
        }
    }

    static class MinHeap {
        private final Accessor[] accessors;
        private final int[] heap;
        private int length;

        MinHeap(Accessor[] accessorArray, int[] nArray, int n2) {
            this.accessors = accessorArray;
            this.heap = nArray;
            this.length = n2;
            this.heapify();
        }

        private void heapify() {
            int n2;
            for (int i2 = n2 = (this.length - 2) / 2; i2 >= 0; --i2) {
                this.heapify(i2);
            }
        }

        private void heapify(int n2) {
            int n3 = n2;
            while (true) {
                int n4 = 2 * n3 + 1;
                int n5 = 2 * n3 + 2;
                int n6 = n3;
                if (n4 < this.length && this.accessors[this.heap[n4]].previousOffset() < this.accessors[this.heap[n6]].previousOffset()) {
                    n6 = n4;
                }
                if (n5 < this.length && this.accessors[this.heap[n5]].previousOffset() < this.accessors[this.heap[n6]].previousOffset()) {
                    n6 = n5;
                }
                if (n6 == n3) break;
                int n7 = this.heap[n3];
                this.heap[n3] = this.heap[n6];
                this.heap[n6] = n7;
                n3 = n6;
            }
        }

        int removeLeast() {
            int n2 = this.heap[0];
            this.heap[0] = this.heap[--this.length];
            this.heapify(0);
            return n2;
        }

        public String toString() {
            String string = "<<" + this.length + ":";
            for (int i2 = 0; i2 < this.length; ++i2) {
                string = string + this.heap[i2] + "|" + this.accessors[this.heap[i2]].previousOffset() + ", ";
            }
            return string + ">>";
        }
    }
}

