/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.nt.DNVerifier;
import oracle.net.nt.SocketChannelWrapper;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
public class SSLSocketChannel
extends SocketChannelWrapper {
    private final SSLEngine sslEngine;
    private ByteBuffer localUnwrapBuffer;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private boolean isClosed = false;
    private boolean isHandshakeDone = false;
    private final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final DNVerifier dnVerifier;
    private SecurityInformation.DNMatchStatus dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;

    public SSLSocketChannel(SocketChannel socketChannel, SSLEngine sSLEngine, DNVerifier dNVerifier) throws IOException {
        super(socketChannel);
        this.socketChannel = socketChannel;
        this.sslEngine = sSLEngine;
        this.dnVerifier = dNVerifier;
        this.initializeBuffers();
    }

    public SSLSocketChannel(SocketChannel socketChannel, SSLEngine sSLEngine) throws IOException {
        this(socketChannel, sSLEngine, null);
    }

    public SecurityInformation.DNMatchStatus getDnMatchStatus() {
        return this.dnMatchStatus;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2;
        if (this.isClosed()) {
            return -1;
        }
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return 0;
        }
        if (!this.isHandshakeDone) {
            this.doSSLHandshake();
        }
        if ((n2 = this.readFromLocalUnwrapBuffer(byteBuffer)) == 0) {
            int n3 = byteBuffer.position();
            this.fillAndUnwrap(byteBuffer);
            n2 = byteBuffer.position() - n3;
        }
        return n2;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.isClosed()) {
            throw new ClosedChannelException();
        }
        if (!this.isHandshakeDone) {
            this.doSSLHandshake();
        }
        if (!this.writeToSocket()) {
            return 0;
        }
        int n2 = byteBuffer.position();
        this.wrapAndWriteToSocket(byteBuffer);
        if (this.writeBuffer.hasRemaining() && !byteBuffer.hasRemaining()) {
            boolean bl = false;
            for (int i2 = 0; !bl && i2 < 10; ++i2) {
                bl = this.writeToSocket();
            }
            if (!bl) {
                throw new IOException("Unable to write to the socket");
            }
        }
        return n2 - byteBuffer.position();
    }

    private void wrapAndWriteToSocket(ByteBuffer byteBuffer) throws IOException {
        boolean bl = false;
        while (byteBuffer.hasRemaining()) {
            SSLEngineResult sSLEngineResult = this.wrap(byteBuffer);
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
                if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (bl) {
                        if (!this.flushWriteBuffer()) break;
                        this.writeBuffer.clear();
                        continue;
                    }
                    throw new IOException("Write error '" + sSLEngineResult.getStatus() + "'");
                }
                this.shutdown();
                throw new IOException("Write error '" + sSLEngineResult.getStatus() + "'");
            }
            bl = true;
            if (sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.runTasks();
        }
        this.flushWriteBuffer();
    }

    private boolean flushWriteBuffer() throws IOException {
        this.writeBuffer.flip();
        return this.writeToSocket();
    }

    public boolean hasRemaining() {
        return this.readBuffer.hasRemaining() || this.localUnwrapBuffer.hasRemaining();
    }

    private boolean fillAndUnwrap(ByteBuffer byteBuffer) throws IOException {
        boolean bl;
        boolean bl2;
        SSLEngineResult sSLEngineResult = null;
        boolean bl3 = false;
        boolean bl4 = bl2 = !this.readBuffer.hasRemaining();
        while (sSLEngineResult == null || sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
            if (bl2) {
                if (this.fillReadBuffer()) {
                    bl2 = false;
                } else {
                    return false;
                }
            }
            if ((sSLEngineResult = bl3 ? this.unwrapToLocalBuffer() : this.unwrapData(byteBuffer)).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (bl3) {
                    throw new IOException("Read error '" + sSLEngineResult.getStatus() + "'");
                }
                bl3 = true;
                bl2 = false;
                continue;
            }
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            bl2 = true;
        }
        boolean bl5 = bl = sSLEngineResult != null && sSLEngineResult.getStatus() == SSLEngineResult.Status.OK;
        if (bl && bl3) {
            this.readFromLocalUnwrapBuffer(byteBuffer);
        }
        return bl;
    }

    private SSLEngineResult unwrapToLocalBuffer() throws IOException {
        assert (!this.localUnwrapBuffer.hasRemaining());
        this.localUnwrapBuffer.clear();
        SSLEngineResult sSLEngineResult = this.unwrapData(this.localUnwrapBuffer);
        this.localUnwrapBuffer.flip();
        return sSLEngineResult;
    }

    private boolean fillReadBuffer() throws IOException {
        if (this.readBuffer.hasRemaining()) {
            this.readBuffer.compact();
        } else {
            this.readBuffer.clear();
        }
        int n2 = this.readFromSocket();
        this.readBuffer.flip();
        return n2 > 0;
    }

    private SSLEngineResult unwrapData(ByteBuffer byteBuffer) throws IOException {
        SSLEngineResult sSLEngineResult = this.unwrap(this.readBuffer, byteBuffer);
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.shutdown();
            throw new IOException("Read error '" + sSLEngineResult.getStatus() + "'");
        }
        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.runTasks();
        }
        return sSLEngineResult;
    }

    private void shutdown() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (!this.sslEngine.isOutboundDone()) {
                this.sslEngine.closeOutbound();
                this.wrap(this.EMPTY_BUFFER);
                this.writeBuffer.flip();
                this.writeToSocket();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeUnderlyingChannel();
    }

    private void closeUnderlyingChannel() {
        try {
            if (this.socketChannel instanceof SocketChannelWrapper) {
                ((SocketChannelWrapper)this.socketChannel).disconnect();
            } else {
                this.socketChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readFromLocalUnwrapBuffer(ByteBuffer byteBuffer) {
        if (!this.localUnwrapBuffer.hasRemaining()) {
            return 0;
        }
        int n2 = Math.min(this.localUnwrapBuffer.remaining(), byteBuffer.remaining());
        for (int i2 = 0; i2 < n2; ++i2) {
            byteBuffer.put(this.localUnwrapBuffer.get());
        }
        return n2;
    }

    private void initializeBuffers() throws SSLException {
        SSLSession sSLSession = this.sslEngine.getSession();
        this.localUnwrapBuffer = ByteBuffer.allocate(sSLSession.getApplicationBufferSize());
        this.readBuffer = ByteBuffer.allocate(sSLSession.getPacketBufferSize());
        this.writeBuffer = ByteBuffer.allocate(sSLSession.getPacketBufferSize());
        this.localUnwrapBuffer.limit(0);
        this.readBuffer.limit(0);
        this.writeBuffer.limit(0);
    }

    private void doSSLHandshake() throws IOException {
        if (this.isHandshakeDone) {
            return;
        }
        this.sslEngine.beginHandshake();
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        block6: while (!this.isHandshakeDone && !this.isClosed) {
            switch (handshakeStatus) {
                case NEED_TASK: {
                    handshakeStatus = this.runTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    handshakeStatus = this.unwrapHandshakeMessage();
                    continue block6;
                }
                case NEED_WRAP: {
                    handshakeStatus = this.wrapHandshakeMessage();
                    continue block6;
                }
                case FINISHED: {
                    this.isHandshakeDone = true;
                    if (this.dnVerifier == null || this.dnVerifier.isWeakDNMatchAllowed()) continue block6;
                    this.verifyDN();
                    continue block6;
                }
            }
            throw new IllegalStateException("Unexpected handshake status '" + handshakeStatus + "'");
        }
    }

    private SSLEngineResult.HandshakeStatus wrapHandshakeMessage() throws IOException {
        SSLEngineResult sSLEngineResult = this.wrap(this.EMPTY_BUFFER);
        SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
            throw new IOException("Handshake failed : " + sSLEngineResult.getStatus());
        }
        this.writeBuffer.flip();
        this.writeToSocket();
        return handshakeStatus;
    }

    private SSLEngineResult.HandshakeStatus unwrapHandshakeMessage() throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        SSLEngineResult sSLEngineResult;
        if (!this.readBuffer.hasRemaining()) {
            this.readBuffer.clear();
            while (this.readFromSocket() == 0) {
            }
            this.readBuffer.flip();
        }
        do {
            this.localUnwrapBuffer.clear();
            sSLEngineResult = this.unwrap(this.readBuffer, this.localUnwrapBuffer);
            handshakeStatus = sSLEngineResult.getHandshakeStatus();
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                this.readBuffer.compact();
                this.readBuffer.flip();
                this.localUnwrapBuffer.flip();
                continue;
            }
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.readBuffer.compact();
                if (this.readBuffer.position() == this.readBuffer.capacity()) {
                    throw new IOException("Handshake failed : SSL packet is too big to hold in the read buffer");
                }
                while (this.readFromSocket() == 0) {
                }
                this.readBuffer.flip();
                continue;
            }
            throw new IOException("Handshake failed : " + sSLEngineResult.getStatus());
        } while (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK);
        return handshakeStatus;
    }

    private SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        try {
            if (this.isEmptyTLSPacket(byteBuffer)) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 5, 0);
            }
            return this.sslEngine.unwrap(byteBuffer, byteBuffer2);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    private boolean isEmptyTLSPacket(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 5) {
            int n2 = byteBuffer.position();
            byte by = byteBuffer.get();
            short s2 = byteBuffer.getShort();
            short s3 = byteBuffer.getShort();
            if (by == 23 && s3 == 0) {
                return true;
            }
            byteBuffer.position(n2);
        }
        return false;
    }

    private SSLEngineResult wrap(ByteBuffer byteBuffer) throws IOException {
        try {
            assert (!this.writeBuffer.hasRemaining());
            this.writeBuffer.clear();
            return this.sslEngine.wrap(byteBuffer, this.writeBuffer);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    private int readFromSocket() throws IOException {
        if (!this.readBuffer.hasRemaining()) {
            throw new IOException("IO Error : No room left in the read buffer");
        }
        try {
            int n2 = this.socketChannel.read(this.readBuffer);
            if (n2 < 0) {
                throw new IOException("Connection closed");
            }
            return n2;
        }
        catch (IOException iOException) {
            try {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.shutdown();
            throw iOException;
        }
    }

    private boolean writeToSocket() throws IOException {
        try {
            this.socketChannel.write(this.writeBuffer);
            return !this.writeBuffer.hasRemaining();
        }
        catch (IOException iOException) {
            this.shutdown();
            throw iOException;
        }
    }

    private boolean isClosed() throws IOException {
        return this.isClosed || !this.socketChannel.isOpen() || this.socketChannel.socket().isInputShutdown() || this.socketChannel.socket().isOutputShutdown();
    }

    private SSLEngineResult.HandshakeStatus runTasks() throws IOException {
        try {
            Runnable runnable;
            while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            return this.sslEngine.getHandshakeStatus();
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    void verifyDN() throws IOException {
        block0: {
            if (this.dnVerifier == null) break block0;
            this.dnMatchStatus = this.dnVerifier.verify((X509Certificate)this.sslEngine.getSession().getPeerCertificates()[0]);
        }
    }

    @Override
    void disconnect() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.shutdown();
    }

    @DisableTrace
    public String toString() {
        return "SSLSocketChannel[" + this.socket().toString() + "]";
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

