/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.StructDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeOPAQUE
extends OracleTypeADT
implements Serializable {
    static final long KOLOFLLB = 1L;
    static final long KOLOFLCL = 2L;
    static final long KOLOFLUB = 4L;
    static final long KOLOFLFX = 8L;
    static final long serialVersionUID = -7279638692691669378L;
    private static final String PUBLIC_XMLTYPE_STRING_VALUE = "PUBLIC.XMLTYPE";
    private static final String SYS_XMLTYPE_STRING_VALUE = "SYS.XMLTYPE";
    private static final String XMLTYPE_STRING_VALUE = "XMLTYPE";
    private static Method XMLTYPE_CREATEXML = null;
    long flagBits;
    long maxLen;

    public OracleTypeOPAQUE(byte[] byArray, int n2, int n3, short s2, String string, long l2) throws SQLException {
        super(byArray, n2, n3, s2, string);
        this.flagBits = l2;
        this.flattenedAttrNum = 1;
    }

    public OracleTypeOPAQUE(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeOPAQUE(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof OPAQUE) {
                return (OPAQUE)object;
            }
            OpaqueDescriptor opaqueDescriptor = this.createOpaqueDescriptor();
            return new OPAQUE(opaqueDescriptor, this.connection, object);
        }
        return null;
    }

    @Override
    public int getTypeCode() {
        return 2007;
    }

    @Override
    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (!(oracleType instanceof OracleTypeOPAQUE)) {
            return false;
        }
        OpaqueDescriptor opaqueDescriptor = (OpaqueDescriptor)oracleType.getTypeDescriptor();
        return this.descriptor.isInHierarchyOf(opaqueDescriptor.getName());
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        tDSReader.skipBytes(5);
        this.flagBits = tDSReader.readLong();
        this.maxLen = tDSReader.readLong();
    }

    @Override
    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if ((byArray[0] & 0x80) > 0) {
            PickleContext pickleContext = new PickleContext(byArray, l2);
            return this.unpickle81(pickleContext, (OPAQUE)datum, n2, map);
        }
        return null;
    }

    @Override
    public byte[] linearize(Datum datum) throws SQLException {
        return this.pickle81(datum);
    }

    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        OPAQUE oPAQUE = (OPAQUE)datum;
        byte[] byArray = oPAQUE.getBytesValue();
        int n2 = 0;
        n2 += pickleContext.writeOpaqueImageHeader(byArray.length);
        return n2 += pickleContext.writeData(byArray);
    }

    OPAQUE unpickle81(PickleContext pickleContext, OPAQUE oPAQUE, int n2, Map map) throws SQLException {
        return this.unpickle81datum(pickleContext, oPAQUE, n2);
    }

    @Override
    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        byte by = pickleContext.readByte();
        Object object = null;
        if (PickleContext.isElementNull(by)) {
            return null;
        }
        pickleContext.skipRestOfLength(by);
        switch (n2) {
            case 1: {
                object = this.unpickle81datum(pickleContext, null);
                break;
            }
            case 2: {
                object = this.unpickle81datum(pickleContext, null).toJdbc();
                break;
            }
            case 3: {
                object = new OPAQUE(this.createOpaqueDescriptor(), pickleContext.readDataValue(), this.connection);
                break;
            }
            case 9: {
                pickleContext.skipDataValue();
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        return object;
    }

    private OPAQUE unpickle81datum(PickleContext pickleContext, OPAQUE oPAQUE) throws SQLException {
        return this.unpickle81datum(pickleContext, oPAQUE, 1);
    }

    private OPAQUE createXml(OPAQUE oPAQUE) throws SQLException {
        Serializable serializable;
        if (XMLTYPE_CREATEXML == null) {
            try {
                serializable = Class.forName("oracle.xdb.XMLType");
                XMLTYPE_CREATEXML = serializable.getMethod("createXML", OPAQUE.class);
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exception).fillInStackTrace();
            }
        }
        try {
            serializable = (OPAQUE)XMLTYPE_CREATEXML.invoke(null, oPAQUE);
            return serializable;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            if (throwable instanceof Exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), (Exception)throwable).fillInStackTrace();
            }
            throw (Error)throwable;
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exception).fillInStackTrace();
        }
    }

    private OPAQUE unpickle81datum(PickleContext pickleContext, OPAQUE oPAQUE, int n2) throws SQLException {
        pickleContext.skipBytes(2);
        long l2 = pickleContext.readLength(true) - 2;
        if (oPAQUE == null) {
            OPAQUE oPAQUE2 = new OPAQUE(this.createOpaqueDescriptor(), this.connection, pickleContext.readBytes((int)l2));
            if (this.typeNameByUser != null ? (this.connection.getVersionNumber() >= 12100 ? this.typeNameByUser.equals(SYS_XMLTYPE_STRING_VALUE) : (this.connection.getVersionNumber() > 10205 ? this.typeNameByUser.equals(PUBLIC_XMLTYPE_STRING_VALUE) : this.typeNameByUser.equals(this.connection.getUserName() + ".XMLTYPE"))) : this.sqlName != null && (this.connection.getVersionNumber() >= 12100 ? this.sqlName.getName().equals(SYS_XMLTYPE_STRING_VALUE) : (this.connection.getVersionNumber() > 10205 ? this.sqlName.getName().equals(PUBLIC_XMLTYPE_STRING_VALUE) : this.sqlName.getName().equals(this.connection.getUserName() + ".XMLTYPE")))) {
                return this.createXml(oPAQUE2);
            }
            return oPAQUE2;
        }
        oPAQUE.setValue(pickleContext.readBytes((int)l2));
        return oPAQUE;
    }

    OpaqueDescriptor createOpaqueDescriptor() throws SQLException {
        if (this.sqlName == null) {
            return new OpaqueDescriptor(this, (Connection)this.connection);
        }
        return OpaqueDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
    }

    public long getMaxLength() throws SQLException {
        return this.maxLen;
    }

    public boolean isTrustedLibrary() throws SQLException {
        return (this.flagBits & 1L) != 0L;
    }

    public boolean isModeledInC() throws SQLException {
        return (this.flagBits & 2L) != 0L;
    }

    public boolean isUnboundedSized() throws SQLException {
        return (this.flagBits & 4L) != 0L;
    }

    public boolean isFixedSized() throws SQLException {
        return (this.flagBits & 8L) != 0L;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

