/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JsonpObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonObjectImpl
implements OracleJsonObject {
    final Map<String, OracleJsonValue> map;

    public OracleJsonObjectImpl() {
        this.map = new LinkedHashMap<String, OracleJsonValue>();
    }

    public OracleJsonObjectImpl(OracleJsonObject oracleJsonObject) {
        this.map = new HashMap<String, OracleJsonValue>();
        block4: for (Map.Entry entry : oracleJsonObject.entrySet()) {
            String string = (String)entry.getKey();
            OracleJsonValue oracleJsonValue = (OracleJsonValue)entry.getValue();
            switch (oracleJsonValue.getOracleJsonType()) {
                case OBJECT: {
                    this.map.put(string, new OracleJsonObjectImpl(oracleJsonValue.asJsonObject()));
                    continue block4;
                }
                case ARRAY: {
                    this.map.put(string, new OracleJsonArrayImpl(oracleJsonValue.asJsonArray()));
                    continue block4;
                }
            }
            this.map.put(string, oracleJsonValue);
        }
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.OBJECT;
    }

    private void checkNull(OracleJsonValue oracleJsonValue) {
        if (oracleJsonValue == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public OracleJsonValue get(Object object) {
        return this.map.get(object);
    }

    @Override
    public OracleJsonValue put(String string, OracleJsonValue oracleJsonValue) {
        this.checkNull(oracleJsonValue);
        return this.map.put(string, oracleJsonValue);
    }

    @Override
    public OracleJsonValue remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends OracleJsonValue> map) {
        for (Map.Entry<? extends String, ? extends OracleJsonValue> entry : map.entrySet()) {
            this.checkNull(entry.getValue());
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<OracleJsonValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, OracleJsonValue>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String getString(String string) {
        return this.map.get(string).asJsonString().getString();
    }

    @Override
    public String getString(String string, String string2) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        return oracleJsonValue == null || oracleJsonValue.getOracleJsonType() != OracleJsonValue.OracleJsonType.STRING ? string2 : oracleJsonValue.asJsonString().getString();
    }

    @Override
    public int getInt(String string) {
        return ((OracleJsonNumber)this.map.get(string)).intValue();
    }

    @Override
    public int getInt(String string, int n2) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        return oracleJsonValue instanceof OracleJsonNumber ? ((OracleJsonNumber)oracleJsonValue).intValue() : n2;
    }

    @Override
    public double getDouble(String string) {
        return ((OracleJsonNumber)this.map.get(string)).doubleValue();
    }

    @Override
    public long getLong(String string) {
        return ((OracleJsonNumber)this.map.get(string)).longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return ((OracleJsonNumber)this.map.get(string)).bigDecimalValue();
    }

    @Override
    public double getDouble(String string, double d2) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        return oracleJsonValue instanceof OracleJsonNumber ? ((OracleJsonNumber)oracleJsonValue).doubleValue() : d2;
    }

    @Override
    public long getLong(String string, long l2) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        return oracleJsonValue instanceof OracleJsonNumber ? ((OracleJsonNumber)oracleJsonValue).longValue() : l2;
    }

    @Override
    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        return oracleJsonValue instanceof OracleJsonNumber ? ((OracleJsonNumber)oracleJsonValue).bigDecimalValue() : bigDecimal;
    }

    @Override
    public boolean getBoolean(String string) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        if (oracleJsonValue.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (oracleJsonValue.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        if (oracleJsonValue == null) {
            return bl;
        }
        if (oracleJsonValue.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (oracleJsonValue.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        return bl;
    }

    @Override
    public boolean isNull(String string) {
        return this.map.get(string).equals(OracleJsonValue.NULL);
    }

    @Override
    public LocalDateTime getLocalDateTime(String string) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return oracleJsonValue.asJsonDate().getLocalDateTime();
        }
        return oracleJsonValue.asJsonTimestamp().getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String string) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        return oracleJsonValue.asJsonTimestampTZ().getOffsetDateTime();
    }

    @Override
    public LocalDateTime getLocalDateTime(String string, LocalDateTime localDateTime) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        if (oracleJsonValue == null) {
            return localDateTime;
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return oracleJsonValue.asJsonDate().getLocalDateTime();
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return oracleJsonValue.asJsonTimestamp().getLocalDateTime();
        }
        return localDateTime;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String string, OffsetDateTime offsetDateTime) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        if (oracleJsonValue == null) {
            return offsetDateTime;
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMPTZ) {
            return oracleJsonValue.asJsonTimestampTZ().getOffsetDateTime();
        }
        return offsetDateTime;
    }

    @Override
    public byte[] getBytes(String string) {
        return this.get(string).asJsonBinary().getBytes();
    }

    @Override
    public byte[] getBytes(String string, byte[] byArray) {
        OracleJsonValue oracleJsonValue = this.map.get(string);
        if (oracleJsonValue == null) {
            return byArray;
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.BINARY) {
            return oracleJsonValue.asJsonBinary().getBytes();
        }
        return byArray;
    }

    @Override
    public OracleJsonValue put(String string, byte[] byArray) {
        return this.map.put(string, new OracleJsonBinaryImpl(byArray, false));
    }

    @Override
    public OracleJsonValue put(String string, String string2) {
        return this.put(string, new OracleJsonStringImpl(string2));
    }

    @Override
    public OracleJsonValue put(String string, int n2) {
        return this.put(string, new OracleJsonDecimalImpl(n2));
    }

    @Override
    public OracleJsonValue put(String string, long l2) {
        return this.put(string, new OracleJsonDecimalImpl(l2));
    }

    @Override
    public OracleJsonValue put(String string, BigDecimal bigDecimal) {
        return this.put(string, new OracleJsonDecimalImpl(bigDecimal));
    }

    @Override
    public OracleJsonValue put(String string, double d2) {
        return this.put(string, new OracleJsonDoubleImpl(d2));
    }

    @Override
    public OracleJsonValue put(String string, boolean bl) {
        return this.put(string, bl ? OracleJsonValue.TRUE : OracleJsonValue.FALSE);
    }

    @Override
    public OracleJsonValue putNull(String string) {
        return this.put(string, OracleJsonValue.NULL);
    }

    @Override
    public OracleJsonValue put(String string, OffsetDateTime offsetDateTime) {
        return this.put(string, new OracleJsonTimestampTZImpl(offsetDateTime));
    }

    @Override
    public OracleJsonValue put(String string, LocalDateTime localDateTime) {
        return this.put(string, new OracleJsonTimestampImpl(localDateTime));
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializerImpl jsonSerializerImpl = new JsonSerializerImpl(stringWriter);
        jsonSerializerImpl.write(this);
        jsonSerializerImpl.close();
        return stringWriter.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(new JsonpObjectImpl(this));
    }
}

