/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={OracleBfile.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableBfile
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETBINSTREAM_METHOD = TxnReplayableBfile.getGetBinaryStreamMethod();
    private static final Method GETBINSTREAM_LONG_METHOD = TxnReplayableBfile.getGetBinaryStreamLongMethod();
    private static final int MAX_CHUNK_SIZE = 32512;

    private static final Method getGetBinaryStreamMethod() {
        try {
            return OracleBfile.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return OracleBfile.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof TxnReplayableBase) {
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)object;
            txnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="closeFile", args={})})
    protected void postForCloseFile(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
        OracleConnection oracleConnection = (OracleConnection)txnReplayableConnection.getDelegate();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oracleConnection.isUsable(false)) {
            this.isLogicallyClosed = true;
            try {
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        super.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
        OracleConnection oracleConnection = (OracleConnection)txnReplayableConnection.getDelegate();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oracleConnection.isUsable(false)) {
            try {
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, new Object[0]);
        try {
            OracleBfile oracleBfile = (OracleBfile)this.getDelegate();
            InputStream inputStream = oracleBfile.getDBAccess().newInputStream((OracleBfile)((Object)this), 32512, 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            OracleBfile oracleBfile = (OracleBfile)this.getDelegate();
            InputStream inputStream = oracleBfile.getDBAccess().newInputStream((OracleBfile)((Object)this), 32512, l2);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        OracleBfile oracleBfile = (OracleBfile)this.getDelegate();
        return oracleBfile.getInternalConnection();
    }
}

