/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.opentelemetry;

import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.provider.opentelemetry.OpenTelemetryTraceEventListener;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.TraceEventListenerProvider;

public class OpenTelemetryTraceEventListenerProvider
implements TraceEventListenerProvider {
    private static final String PROVIDER_NAME = "open-telemetry-trace-event-listener-provider";
    private static final String MBEAN_OBJECT_NAME = "com.oracle.jdbc.extension.opentelemetry:type=OpenTelemetryTraceEventListener";
    private static final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private static ObjectName objectName;
    Logger logger = Logger.getLogger(OpenTelemetryTraceEventListenerProvider.class.getName());

    public TraceEventListener getTraceEventListener(Map<OracleResourceProvider.Parameter, CharSequence> map) {
        try {
            if (objectName != null && server.isRegistered(objectName)) {
                OpenTelemetryTraceEventListener openTelemetryBean = (OpenTelemetryTraceEventListener)server.instantiate(OpenTelemetryTraceEventListener.class.getName());
                return openTelemetryBean;
            }
        }
        catch (MBeanException | ReflectionException e) {
            this.logger.log(Level.WARNING, "Could not retrieve MBean from server", e);
        }
        OpenTelemetryTraceEventListener openTelemetryBean = new OpenTelemetryTraceEventListener();
        try {
            server.registerMBean(openTelemetryBean, objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            this.logger.log(Level.WARNING, "Could not register MBean", e);
        }
        return openTelemetryBean;
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public Collection<? extends OracleResourceProvider.Parameter> getParameters() {
        return Collections.emptyList();
    }

    static {
        try {
            objectName = new ObjectName(MBEAN_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            objectName = null;
        }
    }
}

