/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.resource;

import java.util.Locale;
import java.util.Map;
import oracle.jdbc.provider.oci.database.WalletFactory;
import oracle.jdbc.provider.oci.resource.OciResourceProvider;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.Wallet;
import oracle.jdbc.spi.ConnectionStringProvider;
import oracle.jdbc.spi.OracleResourceProvider;

public final class DatabaseConnectionStringProvider
extends OciResourceProvider
implements ConnectionStringProvider {
    private static final Parameter<String> CONSUMER_GROUP = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("ocid", WalletFactory.OCID), new ResourceParameter("consumerGroup", CONSUMER_GROUP, "MEDIUM")};

    public DatabaseConnectionStringProvider() {
        super("database-connection-string", PARAMETERS);
    }

    public String getConnectionString(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        String consumerGroup;
        ParameterSet parameterSet = this.parseParameterValues(parameterValues);
        Wallet wallet = this.getAutonomousDatabaseWallet(parameterValues);
        switch (consumerGroup = ((String)parameterSet.getRequired(CONSUMER_GROUP)).toUpperCase(Locale.ENGLISH)) {
            case "HIGH": {
                return wallet.getHighConnectionString();
            }
            case "MEDIUM": {
                return wallet.getMediumConnectionString();
            }
            case "LOW": {
                return wallet.getLowConnectionString();
            }
            case "TP": {
                return wallet.getTransactionProcessingConnectionString();
            }
            case "TPURGENT": {
                return wallet.getTransactionProcessingUrgentConnectionString();
            }
        }
        throw new IllegalArgumentException("Unrecognized consumer group: " + consumerGroup);
    }
}

