/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.vault;

import com.oracle.bmc.secrets.model.Base64SecretBundleContentDetails;
import com.oracle.bmc.secrets.model.SecretBundle;
import com.oracle.bmc.secrets.model.SecretBundleContentDetails;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

public final class Secret {
    private final String base64Secret;

    private Secret(String base64Secret) {
        this.base64Secret = base64Secret;
    }

    static Secret fromSecretBundle(SecretBundle secretBundle) {
        SecretBundleContentDetails secretBundleContentDetails = secretBundle.getSecretBundleContent();
        if (secretBundleContentDetails instanceof Base64SecretBundleContentDetails) {
            String base64Secret = ((Base64SecretBundleContentDetails)secretBundleContentDetails).getContent();
            return new Secret(base64Secret);
        }
        throw new IllegalStateException("Unsupported content type: " + secretBundleContentDetails.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        byte[] contentBytes = Base64.getDecoder().decode(this.base64Secret);
        try {
            char[] cArray;
            CharBuffer contentBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(contentBytes));
            char[] contentChars = new char[contentBuffer.remaining()];
            try {
                contentBuffer.get(contentChars);
                cArray = contentChars;
                contentBuffer.clear();
            }
            catch (Throwable throwable) {
                contentBuffer.clear();
                contentBuffer.put(new char[contentBuffer.capacity()]);
                throw throwable;
            }
            contentBuffer.put(new char[contentBuffer.capacity()]);
            return cArray;
        }
        finally {
            Arrays.fill(contentBytes, (byte)0);
        }
    }

    public String getBase64Secret() {
        return this.base64Secret;
    }
}

