/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.resource;

import java.util.Base64;
import java.util.Map;
import oracle.jdbc.provider.oci.resource.OciResourceProvider;
import oracle.jdbc.provider.oci.vault.Secret;
import oracle.jdbc.provider.oci.vault.SecretFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.WalletUtils;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.PasswordProvider;
import oracle.jdbc.spi.UsernameProvider;

public class VaultSEPSProvider
extends OciResourceProvider
implements UsernameProvider,
PasswordProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("ocid", SecretFactory.OCID), new ResourceParameter("walletPassword", CommonParameters.PASSWORD), new ResourceParameter("connectionStringIndex", CommonParameters.CONNECTION_STRING_INDEX)};

    public VaultSEPSProvider() {
        super("vault-seps", PARAMETERS);
    }

    public String getUsername(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.getWalletCredentials(parameterValues).username();
    }

    public char[] getPassword(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.getWalletCredentials(parameterValues).password();
    }

    private WalletUtils.Credentials getWalletCredentials(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        ParameterSet parameterSet = this.parseParameterValues(parameterValues);
        Secret secret = this.getVaultSecret(parameterValues);
        char[] walletPassword = parameterSet.getOptional(CommonParameters.PASSWORD) != null ? ((String)parameterSet.getOptional(CommonParameters.PASSWORD)).toCharArray() : null;
        String connectionStringIndex = (String)parameterSet.getOptional(CommonParameters.CONNECTION_STRING_INDEX);
        byte[] walletBytes = Base64.getDecoder().decode(secret.getBase64Secret());
        return WalletUtils.getCredentials((byte[])walletBytes, (char[])walletPassword, (String)connectionStringIndex);
    }
}

