/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.configuration;

import oracle.jdbc.provider.oci.authentication.AuthenticationDetailsFactory;
import oracle.jdbc.provider.oci.authentication.AuthenticationMethod;
import oracle.jdbc.provider.oci.objectstorage.ObjectFactory;
import oracle.jdbc.provider.oci.vault.SecretFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSetParser;

public final class OciConfigurationParameters {
    public static final Parameter<String> KEY = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    private static final ParameterSetParser PARAMETER_SET_PARSER = ParameterSetParser.builder().addParameter("key", KEY, "").addParameter("value", SecretFactory.OCID, "").addParameter("type", Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0])).addParameter("object_url", ObjectFactory.OBJECT_URL, "").addParameter("AUTHENTICATION", AuthenticationDetailsFactory.AUTHENTICATION_METHOD, (Object)AuthenticationMethod.API_KEY, OciConfigurationParameters::parseAuthentication).addParameter("OCI_PROFILE", AuthenticationDetailsFactory.CONFIG_PROFILE, "DEFAULT").addParameter("OCI_TENANCY", AuthenticationDetailsFactory.TENANT_ID).addParameter("OCI_USER", AuthenticationDetailsFactory.USER_ID).addParameter("OCI_FINGERPRINT", AuthenticationDetailsFactory.FINGERPRINT).addParameter("OCI_KEY_FILE", AuthenticationDetailsFactory.PRIVATE_KEY).addParameter("OCI_PASS_PHRASE", AuthenticationDetailsFactory.PASS_PHRASE).build();

    private OciConfigurationParameters() {
    }

    public static ParameterSetParser getParser() {
        return PARAMETER_SET_PARSER;
    }

    private static AuthenticationMethod parseAuthentication(String authentication) {
        switch (authentication) {
            case "OCI_DEFAULT": {
                return AuthenticationMethod.API_KEY;
            }
            case "OCI_INSTANCE_PRINCIPAL": {
                return AuthenticationMethod.INSTANCE_PRINCIPAL;
            }
            case "OCI_RESOURCE_PRINCIPAL": {
                return AuthenticationMethod.RESOURCE_PRINCIPAL;
            }
            case "OCI_INTERACTIVE": {
                return AuthenticationMethod.INTERACTIVE;
            }
        }
        throw new IllegalArgumentException("Unrecognized value: " + authentication);
    }
}

