/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.resource;

import java.util.Base64;
import java.util.Map;
import javax.net.ssl.SSLContext;
import oracle.jdbc.provider.oci.resource.OciResourceProvider;
import oracle.jdbc.provider.oci.vault.Secret;
import oracle.jdbc.provider.oci.vault.SecretFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.TlsUtils;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.TlsConfigurationProvider;

public class VaultTCPSProvider
extends OciResourceProvider
implements TlsConfigurationProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("ocid", SecretFactory.OCID), new ResourceParameter("walletPassword", CommonParameters.PASSWORD), new ResourceParameter("type", CommonParameters.TYPE)};

    public VaultTCPSProvider() {
        super("vault-tls", PARAMETERS);
    }

    public SSLContext getSSLContext(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        try {
            ParameterSet parameterSet = this.parseParameterValues(parameterValues);
            Secret secret = this.getVaultSecret(parameterValues);
            byte[] fileBytes = Base64.getDecoder().decode(secret.getBase64Secret());
            char[] password = parameterSet.getOptional(CommonParameters.PASSWORD) != null ? ((String)parameterSet.getOptional(CommonParameters.PASSWORD)).toCharArray() : null;
            String type = (String)parameterSet.getRequired(CommonParameters.TYPE);
            return TlsUtils.createSSLContext((byte[])fileBytes, (char[])password, (String)type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create SSLContext from the file", e);
        }
    }
}

