/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.resource;

import com.oracle.bmc.Region;
import java.util.stream.Stream;
import oracle.jdbc.provider.oci.authentication.AuthenticationDetailsFactory;
import oracle.jdbc.provider.oci.authentication.AuthenticationMethod;
import oracle.jdbc.provider.resource.AbstractResourceProvider;
import oracle.jdbc.provider.resource.ResourceParameter;

public abstract class OciResourceProvider
extends AbstractResourceProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("authenticationMethod", AuthenticationDetailsFactory.AUTHENTICATION_METHOD, "auto-detect", OciResourceProvider::parseAuthenticationMethod), new ResourceParameter("configFile", AuthenticationDetailsFactory.CONFIG_FILE_PATH), new ResourceParameter("profile", AuthenticationDetailsFactory.CONFIG_PROFILE), new ResourceParameter("tenantId", AuthenticationDetailsFactory.TENANT_ID), new ResourceParameter("username", AuthenticationDetailsFactory.USERNAME), new ResourceParameter("region", AuthenticationDetailsFactory.REGION, null, Region::fromRegionCodeOrId)};

    protected OciResourceProvider(String valueType, ResourceParameter ... parameters) {
        super("oci", valueType, (ResourceParameter[])Stream.concat(Stream.of(PARAMETERS), Stream.of(parameters)).toArray(ResourceParameter[]::new));
    }

    private static AuthenticationMethod parseAuthenticationMethod(String authenticationMethod) {
        switch (authenticationMethod) {
            case "config-file": {
                return AuthenticationMethod.CONFIG_FILE;
            }
            case "instance-principal": {
                return AuthenticationMethod.INSTANCE_PRINCIPAL;
            }
            case "resource-principal": {
                return AuthenticationMethod.RESOURCE_PRINCIPAL;
            }
            case "cloud-shell": {
                return AuthenticationMethod.CLOUD_SHELL;
            }
            case "interactive": {
                return AuthenticationMethod.INTERACTIVE;
            }
            case "auto-detect": {
                return AuthenticationMethod.AUTO_DETECT;
            }
        }
        throw new IllegalArgumentException(authenticationMethod);
    }
}

