/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.oauth;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.identitydataplane.DataplaneClient;
import com.oracle.bmc.identitydataplane.model.GenerateScopedAccessTokenDetails;
import com.oracle.bmc.identitydataplane.model.SecurityToken;
import com.oracle.bmc.identitydataplane.requests.GenerateScopedAccessTokenRequest;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Base64;
import javax.security.auth.DestroyFailedException;
import oracle.jdbc.AccessToken;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.oci.OciResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.util.JsonWebTokenParser;

public final class AccessTokenFactory
extends OciResourceFactory<AccessToken> {
    public static final Parameter<String> SCOPE = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<AccessToken> INSTANCE = CachedResourceFactory.create((ResourceFactory)new AccessTokenFactory());

    private AccessTokenFactory() {
    }

    public static ResourceFactory<AccessToken> getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource<AccessToken> request(AbstractAuthenticationDetailsProvider authenticationDetails, ParameterSet parameterSet) {
        KeyPair keyPair = AccessTokenFactory.generateKeyPair();
        String scope = (String)parameterSet.getRequired(SCOPE);
        SecurityToken securityToken = AccessTokenFactory.requestSecurityToken(authenticationDetails, scope, keyPair.getPublic());
        PrivateKey privateKey = keyPair.getPrivate();
        try {
            Resource<AccessToken> resource = AccessTokenFactory.createResource(securityToken, privateKey);
            return resource;
        }
        finally {
            AccessTokenFactory.tryDestroy(keyPair.getPrivate());
        }
    }

    private static KeyPair generateKeyPair() {
        try {
            return KeyPairGenerator.getInstance("RSA").generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Failed to generated a proof of possession key pair. See cause for details.", noSuchAlgorithmException);
        }
    }

    private static SecurityToken requestSecurityToken(AbstractAuthenticationDetailsProvider authenticationDetails, String scope, PublicKey publicKey) {
        try (DataplaneClient client = DataplaneClient.builder().build(authenticationDetails);){
            String base64PublicKey = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            GenerateScopedAccessTokenDetails details = GenerateScopedAccessTokenDetails.builder().publicKey(base64PublicKey).scope(scope).build();
            GenerateScopedAccessTokenRequest request = GenerateScopedAccessTokenRequest.builder().generateScopedAccessTokenDetails(details).build();
            SecurityToken securityToken = client.generateScopedAccessToken(request).getSecurityToken();
            return securityToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource<AccessToken> createResource(SecurityToken securityToken, PrivateKey privateKey) {
        AccessToken accessToken;
        String token = securityToken.getToken();
        OffsetDateTime expireTime = JsonWebTokenParser.parseExp((CharSequence)token);
        char[] tokenChars = token.toCharArray();
        try {
            accessToken = AccessToken.createJsonWebToken((char[])tokenChars, (PrivateKey)privateKey);
        }
        finally {
            Arrays.fill(tokenChars, '\u0000');
        }
        return Resource.createExpiringResource((Object)accessToken, (OffsetDateTime)expireTime, (boolean)true);
    }

    private static void tryDestroy(PrivateKey privateKey) {
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }
}

