/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.database;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class WalletPasswordGenerator {
    private static final char[] LOWER_CASE_CHARACTERS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] UPPER_CASE_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] NUMERIC_CHARACTERS = "0123456789".toCharArray();
    private static final char[] SPECIAL_CHARACTERS = "!\"#$%&'*+,./:;=?@\\^`|~".toCharArray();
    private static final char[] ALL_CHARACTERS = Stream.of(LOWER_CASE_CHARACTERS, UPPER_CASE_CHARACTERS, NUMERIC_CHARACTERS, SPECIAL_CHARACTERS).map(String::new).collect(Collectors.joining()).toCharArray();

    private WalletPasswordGenerator() {
    }

    static char[] generatePassword() {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Failed to create random number generator", noSuchAlgorithmException);
        }
        char[] password = new char[128];
        for (int i = 0; i < password.length; ++i) {
            password[i] = ALL_CHARACTERS[secureRandom.nextInt(ALL_CHARACTERS.length)];
        }
        password[secureRandom.nextInt((int)password.length)] = UPPER_CASE_CHARACTERS[secureRandom.nextInt(UPPER_CASE_CHARACTERS.length)];
        password[secureRandom.nextInt((int)password.length)] = LOWER_CASE_CHARACTERS[secureRandom.nextInt(LOWER_CASE_CHARACTERS.length)];
        password[secureRandom.nextInt((int)password.length)] = NUMERIC_CHARACTERS[secureRandom.nextInt(NUMERIC_CHARACTERS.length)];
        password[secureRandom.nextInt((int)password.length)] = SPECIAL_CHARACTERS[secureRandom.nextInt(SPECIAL_CHARACTERS.length)];
        return password;
    }
}

