/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.database;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.GenerateAutonomousDatabaseWalletDetails;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipInputStream;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.oci.OciResourceFactory;
import oracle.jdbc.provider.oci.database.Wallet;
import oracle.jdbc.provider.oci.database.WalletPasswordGenerator;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public final class WalletFactory
extends OciResourceFactory<Wallet> {
    public static final Parameter<String> OCID = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    private static final ResourceFactory<Wallet> INSTANCE = CachedResourceFactory.create((ResourceFactory)new WalletFactory());

    private WalletFactory() {
    }

    public static ResourceFactory<Wallet> getInstance() {
        return INSTANCE;
    }

    @Override
    protected Resource<Wallet> request(AbstractAuthenticationDetailsProvider authenticationDetails, ParameterSet parameterSet) {
        String ocid = (String)parameterSet.getRequired(OCID);
        char[] password = WalletPasswordGenerator.generatePassword();
        try {
            Resource resource;
            block17: {
                DatabaseClient databaseClient = DatabaseClient.builder().build(authenticationDetails);
                try {
                    Wallet wallet;
                    GenerateAutonomousDatabaseWalletDetails details = GenerateAutonomousDatabaseWalletDetails.builder().password(new String(password)).build();
                    GenerateAutonomousDatabaseWalletRequest request = GenerateAutonomousDatabaseWalletRequest.builder().autonomousDatabaseId(ocid).generateAutonomousDatabaseWalletDetails(details).build();
                    GenerateAutonomousDatabaseWalletResponse response = databaseClient.generateAutonomousDatabaseWallet(request);
                    InputStream responseStream = response.getInputStream();
                    try (ZipInputStream zipStream = new ZipInputStream(responseStream);){
                        wallet = Wallet.unzip(zipStream, password);
                    }
                    catch (IOException ioException) {
                        throw new IllegalStateException("Failed to close ZIP stream", ioException);
                    }
                    resource = Resource.createPermanentResource((Object)wallet, (boolean)false);
                    if (databaseClient == null) break block17;
                }
                catch (Throwable throwable) {
                    if (databaseClient != null) {
                        try {
                            databaseClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                databaseClient.close();
            }
            return resource;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }
}

