/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.database;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import oracle.jdbc.provider.oci.database.TNSNames;

public final class Wallet {
    private static final String TNS_NAMES_FILE = "tnsnames.ora";
    private static final String KEY_STORE_FILE = "keystore.jks";
    private static final String TRUST_STORE_FILE = "truststore.jks";
    private static final String KEY_STORE_TYPE = "JKS";
    private final TNSNames tnsNames;
    private final SSLContext sslContext;

    private Wallet(TNSNames tnsNames, SSLContext sslContext) {
        this.tnsNames = tnsNames;
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String getHighConnectionString() {
        return this.getConnectionString(TNSNames.ConsumerGroup.HIGH);
    }

    public String getMediumConnectionString() {
        return this.getConnectionString(TNSNames.ConsumerGroup.MEDIUM);
    }

    public String getLowConnectionString() {
        return this.getConnectionString(TNSNames.ConsumerGroup.LOW);
    }

    public String getTransactionProcessingConnectionString() {
        return this.getConnectionString(TNSNames.ConsumerGroup.TRANSACTION_PROCESSING);
    }

    public String getTransactionProcessingUrgentConnectionString() {
        return this.getConnectionString(TNSNames.ConsumerGroup.TRANSACTION_PROCESSING_URGENT);
    }

    private String getConnectionString(TNSNames.ConsumerGroup consumerGroup) {
        String connectionString = this.tnsNames.getConnectionString(consumerGroup);
        if (connectionString == null) {
            throw new IllegalStateException("No connection string available for consumer group: " + (Object)((Object)consumerGroup));
        }
        return connectionString;
    }

    static Wallet unzip(ZipInputStream zipStream, char[] password) {
        TNSNames tnsNames = null;
        KeyStore keyStore = null;
        KeyStore trustStore = null;
        try {
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                switch (entry.getName()) {
                    case "tnsnames.ora": {
                        tnsNames = TNSNames.read(zipStream);
                        break;
                    }
                    case "keystore.jks": {
                        keyStore = Wallet.loadKeyStore(zipStream, password);
                        break;
                    }
                    case "truststore.jks": {
                        trustStore = Wallet.loadKeyStore(zipStream, null);
                        break;
                    }
                }
                entry = zipStream.getNextEntry();
            }
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failed to read wallet ZIP", ioException);
        }
        if (tnsNames == null) {
            throw Wallet.missingFile(TNS_NAMES_FILE);
        }
        if (keyStore == null) {
            throw Wallet.missingFile(KEY_STORE_FILE);
        }
        if (trustStore == null) {
            throw Wallet.missingFile(TRUST_STORE_FILE);
        }
        return new Wallet(tnsNames, Wallet.createSSLContext(keyStore, trustStore, password));
    }

    private static IllegalStateException missingFile(String fileName) {
        return new IllegalStateException("Wallet ZIP did not contain: " + fileName);
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore, char[] password) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Failed initialize SSLContext", generalSecurityException);
        }
    }

    private static KeyStore loadKeyStore(InputStream inputStream, char[] password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            keyStore.load(inputStream, password);
            return keyStore;
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new IllegalStateException("Failed to load KeyStore", exception);
        }
    }
}

