/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.configuration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import oracle.jdbc.driver.OracleConfigurationJsonProvider;
import oracle.jdbc.provider.oci.configuration.OciConfigurationParameters;
import oracle.jdbc.provider.oci.vault.Secret;
import oracle.jdbc.provider.oci.vault.SecretFactory;
import oracle.jdbc.provider.parameter.ParameterSet;

public class OciVaultJsonProvider
extends OracleConfigurationJsonProvider {
    public InputStream getJson(String secretOcid) {
        String valueFieldName = "value";
        HashMap<String, String> optionsWithOcid = new HashMap<String, String>(this.options);
        optionsWithOcid.put("value", secretOcid);
        ParameterSet parameters = OciConfigurationParameters.getParser().parseNamedValues(optionsWithOcid);
        String secretContent = ((Secret)SecretFactory.getInstance().request(parameters).getContent()).getBase64Secret();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(secretContent));
        return inputStream;
    }

    public String getType() {
        return "ocivault";
    }
}

