/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.configuration;

import com.oracle.bmc.databasetools.model.DatabaseToolsConnection;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionOracleDatabase;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionOracleDatabaseProxyClient;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionOracleDatabaseProxyClientUserName;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStore;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStoreContent;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStoreContentSecretId;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStorePassword;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStorePasswordSecretId;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPassword;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPasswordSecretId;
import com.oracle.bmc.databasetools.model.LifecycleState;
import com.oracle.bmc.model.BmcException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import oracle.jdbc.provider.oci.configuration.OciConfigurationParameters;
import oracle.jdbc.provider.oci.databasetools.DatabaseToolsConnectionFactory;
import oracle.jdbc.provider.oci.vault.Secret;
import oracle.jdbc.provider.oci.vault.SecretFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.spi.OracleConfigurationCachableProvider;
import oracle.jdbc.spi.OracleConfigurationProvider;
import oracle.jdbc.util.OracleConfigurationCache;
import oracle.jdbc.util.OracleConfigurationProviderNetworkError;

public class OciDatabaseToolsConnectionProvider
implements OracleConfigurationCachableProvider {
    private static final String CONFIG_TIME_TO_LIVE = "config_time_to_live";
    private static final long MS_REFRESH_TIMEOUT = 60000L;
    private static final long MS_RETRY_INTERVAL = 60000L;
    private static final OracleConfigurationCache cache = OracleConfigurationCache.create((int)100);
    private ParameterSet commonParameters;

    public Properties getConnectionProperties(String location) throws SQLException {
        Properties cachedProp = cache.get(location);
        if (Objects.nonNull(cachedProp)) {
            return cachedProp;
        }
        Properties properties = this.getRemoteProperties(location);
        if (properties.containsKey(CONFIG_TIME_TO_LIVE)) {
            long configTimeToLive = Long.parseLong(properties.getProperty(CONFIG_TIME_TO_LIVE));
            properties.remove(CONFIG_TIME_TO_LIVE);
            cache.put(location, properties, configTimeToLive, () -> this.refreshProperties(location), 60000L, 60000L);
        } else {
            cache.put(location, properties, () -> this.refreshProperties(location), 60000L, 60000L);
        }
        return properties;
    }

    public String getType() {
        return "ocidbtools";
    }

    private Properties getRemoteProperties(String location) {
        DatabaseToolsConnectionOracleDatabaseProxyClient proxyClient;
        Map advancedProps;
        DatabaseToolsUserPassword dbToolsUserPassword;
        Map options = null;
        String[] params = location.split("\\?");
        options = params.length > 1 ? OracleConfigurationProvider.mapOptions((String)params[1]) : new HashMap();
        this.commonParameters = OciConfigurationParameters.getParser().parseNamedValues(options).copyBuilder().add("connection_ocid", DatabaseToolsConnectionFactory.CONNECTION_OCID, (Object)params[0]).build();
        DatabaseToolsConnection dbToolsConnection = (DatabaseToolsConnection)DatabaseToolsConnectionFactory.getInstance().request(this.commonParameters).getContent();
        if (!(dbToolsConnection instanceof DatabaseToolsConnectionOracleDatabase)) {
            throw new IllegalStateException("Unsupported class type: " + dbToolsConnection.getClass().getTypeName());
        }
        DatabaseToolsConnectionOracleDatabase connection = (DatabaseToolsConnectionOracleDatabase)dbToolsConnection;
        LifecycleState state = connection.getLifecycleState();
        if (!state.equals((Object)LifecycleState.Active) && !state.equals((Object)LifecycleState.Updating)) {
            throw new IllegalStateException("Connection requested is in invalid state. Only ACTIVE or UPDATING are valid. Current state: " + state);
        }
        Properties properties = new Properties();
        properties.put("URL", "jdbc:oracle:thin:@" + connection.getConnectionString());
        String username = connection.getUserName();
        if (username != null) {
            properties.put("user", username);
        }
        if ((dbToolsUserPassword = connection.getUserPassword()) != null) {
            properties.put("password", String.valueOf(this.getSecret(dbToolsUserPassword).toCharArray()));
        }
        if (connection.getKeyStores() != null) {
            Properties walletProps = new Properties();
            block5: for (DatabaseToolsKeyStore keyStore : connection.getKeyStores()) {
                String base64KeyStoreContent = this.getSecret(keyStore.getKeyStoreContent()).getBase64Secret();
                DatabaseToolsKeyStorePassword keyStorePassword = keyStore.getKeyStorePassword();
                switch (keyStore.getKeyStoreType()) {
                    case JavaKeyStore: {
                        walletProps.setProperty("javax.net.ssl.keyStoreType", "JKS");
                        walletProps.setProperty("javax.net.ssl.keyStore", "data:;base64," + base64KeyStoreContent);
                        walletProps.setProperty("javax.net.ssl.keyStorePassword", String.valueOf(this.getSecret(keyStorePassword).toCharArray()));
                        continue block5;
                    }
                    case JavaTrustStore: {
                        walletProps.setProperty("javax.net.ssl.trustStoreType", "JKS");
                        walletProps.setProperty("javax.net.ssl.trustStore", "data:;base64," + base64KeyStoreContent);
                        walletProps.setProperty("javax.net.ssl.trustStorePassword", String.valueOf(this.getSecret(keyStorePassword).toCharArray()));
                        continue block5;
                    }
                    case Pkcs12: 
                    case Sso: {
                        walletProps.put("oracle.net.wallet_location", "data:;base64," + base64KeyStoreContent);
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unknown keyStore type: " + keyStore.getKeyStoreType());
            }
            properties.putAll((Map<?, ?>)walletProps);
        }
        if ((advancedProps = connection.getAdvancedProperties()) != null) {
            properties.putAll((Map<?, ?>)connection.getAdvancedProperties());
        }
        if ((proxyClient = connection.getProxyClient()) instanceof DatabaseToolsConnectionOracleDatabaseProxyClientUserName) {
            DatabaseToolsConnectionOracleDatabaseProxyClientUserName proxyClientUserName = (DatabaseToolsConnectionOracleDatabaseProxyClientUserName)proxyClient;
            if (proxyClientUserName.getUserPassword() != null || proxyClientUserName.getRoles() != null) {
                throw new UnsupportedOperationException("Unsupported feature: the proxyClient of this database tools connection has user password or roles");
            }
            properties.put("oracle.jdbc.proxyClientName", proxyClientUserName.getUserName());
        }
        return properties;
    }

    private Secret getSecret(DatabaseToolsUserPassword userPassword) {
        if (!(userPassword instanceof DatabaseToolsUserPasswordSecretId)) {
            throw new IllegalStateException("Unsupported class type: " + userPassword.getClass().getTypeName());
        }
        String secretId = ((DatabaseToolsUserPasswordSecretId)userPassword).getSecretId();
        return this.requestSecretFromOCI(secretId);
    }

    private Secret getSecret(DatabaseToolsKeyStoreContent keyStoreContent) {
        if (!(keyStoreContent instanceof DatabaseToolsKeyStoreContentSecretId)) {
            throw new IllegalStateException("Unsupported class type: " + keyStoreContent.getClass().getTypeName());
        }
        String secretId = ((DatabaseToolsKeyStoreContentSecretId)keyStoreContent).getSecretId();
        return this.requestSecretFromOCI(secretId);
    }

    private Secret getSecret(DatabaseToolsKeyStorePassword keyStorePassword) {
        if (!(keyStorePassword instanceof DatabaseToolsKeyStorePasswordSecretId)) {
            throw new IllegalStateException("Unsupported class type: " + keyStorePassword.getClass().getTypeName());
        }
        String secretId = ((DatabaseToolsKeyStorePasswordSecretId)keyStorePassword).getSecretId();
        return this.requestSecretFromOCI(secretId);
    }

    private Secret requestSecretFromOCI(String secretId) {
        ParameterSet walletParameters = this.commonParameters.copyBuilder().add("value", SecretFactory.OCID, (Object)secretId).build();
        return (Secret)SecretFactory.getInstance().request(walletParameters).getContent();
    }

    public Properties removeProperties(String location) {
        Properties deletedProp = cache.remove(location);
        return deletedProp;
    }

    private Properties refreshProperties(String location) throws OracleConfigurationProviderNetworkError {
        try {
            return this.getRemoteProperties(location);
        }
        catch (BmcException bmcException) {
            throw new OracleConfigurationProviderNetworkError((Exception)((Object)bmcException));
        }
    }
}

