/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.authentication;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import oracle.jdbc.provider.util.JsonWebTokenParser;
import oracle.jdbc.provider.util.PemData;

public class InteractiveAuthenticationDetails
implements AuthenticationDetailsProvider,
RegionProvider {
    private final Region region;
    private final String keyId;
    private final String fingerprint;
    private final String tenantId;
    private final String userId;
    private final PemData privateKey;

    InteractiveAuthenticationDetails(Region region, String sessionToken, KeyPair proofOfPossession) {
        this.region = region;
        this.privateKey = PemData.encodePrivateKey((PrivateKey)proofOfPossession.getPrivate());
        this.fingerprint = InteractiveAuthenticationDetails.encodeFingerprint(proofOfPossession.getPublic());
        Map tokenClaims = JsonWebTokenParser.parseClaims((CharSequence)sessionToken);
        this.tenantId = (String)tokenClaims.get("tenant");
        this.userId = (String)tokenClaims.get("sub");
        this.keyId = "ST$" + sessionToken;
    }

    public Region getRegion() {
        return this.region;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    public InputStream getPrivateKey() {
        return this.privateKey.createInputStream();
    }

    public String getPassPhrase() {
        return null;
    }

    public char[] getPassphraseCharacters() {
        return null;
    }

    private static String encodeFingerprint(PublicKey publicKey) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noMd5) {
            throw new IllegalStateException("Failed to create an MD5 digest", noMd5);
        }
        md5.update(publicKey.getEncoded());
        byte[] hash = md5.digest();
        StringBuilder builder = new StringBuilder(hash.length * 2 + (hash.length - 1));
        builder.append(Integer.toHexString(Byte.toUnsignedInt(hash[0])));
        for (int i = 1; i < hash.length; ++i) {
            builder.append(':');
            builder.append(Integer.toHexString(Byte.toUnsignedInt(hash[i])));
        }
        return builder.toString();
    }
}

