/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.authentication;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.oci.authentication.AuthenticationMethod;
import oracle.jdbc.provider.oci.authentication.InteractiveAuthentication;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public final class AuthenticationDetailsFactory
implements ResourceFactory<AbstractAuthenticationDetailsProvider> {
    public static final Parameter<AuthenticationMethod> AUTHENTICATION_METHOD = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> CONFIG_FILE_PATH = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> CONFIG_PROFILE = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> TENANT_ID = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> USER_ID = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> FINGERPRINT = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> PRIVATE_KEY = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.SENSITIVE});
    public static final Parameter<String> PASS_PHRASE = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.SENSITIVE});
    public static final Parameter<String> USERNAME = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<Region> REGION = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    private static final AuthenticationDetailsFactory INSTANCE = new AuthenticationDetailsFactory();

    private AuthenticationDetailsFactory() {
    }

    public static AuthenticationDetailsFactory getInstance() {
        return INSTANCE;
    }

    public Resource<AbstractAuthenticationDetailsProvider> request(ParameterSet parameterSet) {
        AbstractAuthenticationDetailsProvider authenticationDetails = AuthenticationDetailsFactory.getAuthenticationDetails(parameterSet);
        return Resource.createPermanentResource((Object)authenticationDetails, (boolean)true);
    }

    private static AbstractAuthenticationDetailsProvider getAuthenticationDetails(ParameterSet parameterSet) {
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)((Object)parameterSet.getRequired(AUTHENTICATION_METHOD));
        switch (authenticationMethod) {
            case CONFIG_FILE: {
                return AuthenticationDetailsFactory.configFileAuthentication(parameterSet);
            }
            case CLOUD_SHELL: {
                return AuthenticationDetailsFactory.cloudShellAuthentication();
            }
            case INSTANCE_PRINCIPAL: {
                return AuthenticationDetailsFactory.instancePrincipalAuthentication();
            }
            case RESOURCE_PRINCIPAL: {
                return AuthenticationDetailsFactory.resourcePrincipalAuthentication();
            }
            case INTERACTIVE: {
                return InteractiveAuthentication.getSessionToken(parameterSet);
            }
            case AUTO_DETECT: {
                return AuthenticationDetailsFactory.autoDetectAuthentication(parameterSet);
            }
            case API_KEY: {
                return AuthenticationDetailsFactory.apiKeyBasedAuthentication(parameterSet);
            }
        }
        throw new IllegalArgumentException("Unrecognized authentication method: " + (Object)((Object)authenticationMethod));
    }

    private static ConfigFileAuthenticationDetailsProvider configFileAuthentication(ParameterSet parameters) {
        return AuthenticationDetailsFactory.configFileAuthentication((String)parameters.getOptional(CONFIG_FILE_PATH), (String)parameters.getOptional(CONFIG_PROFILE));
    }

    private static AuthenticationDetailsProvider simpleAuthentication(ParameterSet parameters) {
        return AuthenticationDetailsFactory.simpleAuthentication((String)parameters.getRequired(TENANT_ID), (String)parameters.getRequired(USER_ID), (String)parameters.getRequired(FINGERPRINT), (String)parameters.getRequired(PRIVATE_KEY), (String)parameters.getOptional(PASS_PHRASE), (Region)parameters.getOptional(REGION));
    }

    private static AuthenticationDetailsProvider apiKeyBasedAuthentication(ParameterSet parameters) {
        if (parameters.contains(TENANT_ID) || parameters.contains(USER_ID) || parameters.contains(FINGERPRINT) || parameters.contains(PRIVATE_KEY) || parameters.contains(PASS_PHRASE) || parameters.contains(REGION)) {
            return AuthenticationDetailsFactory.simpleAuthentication(parameters);
        }
        return AuthenticationDetailsFactory.configFileAuthentication(parameters);
    }

    private static BasicAuthenticationDetailsProvider autoDetectAuthentication(ParameterSet parameters) {
        try {
            return AuthenticationDetailsFactory.configFileAuthentication(parameters);
        }
        catch (RuntimeException noConfigFile) {
            IllegalStateException previousFailure = new IllegalStateException("Failed to authenticate using a configuration file", noConfigFile);
            try {
                return AuthenticationDetailsFactory.cloudShellAuthentication();
            }
            catch (RuntimeException notCloudShell) {
                previousFailure.addSuppressed(new IllegalStateException("Failed to authenticate using a cloud shell delegation token", notCloudShell));
                try {
                    return AuthenticationDetailsFactory.resourcePrincipalAuthentication();
                }
                catch (RuntimeException notContainer) {
                    previousFailure.addSuppressed(new IllegalStateException("Failed to authenticate as a resource principal", notContainer));
                    try {
                        return AuthenticationDetailsFactory.instancePrincipalAuthentication();
                    }
                    catch (RuntimeException notComputeInstance) {
                        previousFailure.addSuppressed(new IllegalStateException("Failed to authenticate as an instance principal", notComputeInstance));
                        throw previousFailure;
                    }
                }
            }
        }
    }

    private static InstancePrincipalsAuthenticationDetailsProvider instancePrincipalAuthentication() {
        try {
            return (InstancePrincipalsAuthenticationDetailsProvider)InstancePrincipalAuthenticationTask.FUTURE.get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException exception) {
            throw new IllegalStateException("Failed to authenticate as an instance principal", exception.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Authentication as an instance principal was interrupted", interruptedException);
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException("Authentication as an instance principal did not complete within 5 seconds", timeoutException);
        }
    }

    private static ResourcePrincipalAuthenticationDetailsProvider resourcePrincipalAuthentication() {
        return ResourcePrincipalAuthenticationDetailsProvider.builder().build();
    }

    private static AuthenticationDetailsProvider cloudShellAuthentication() {
        String envConfigFile = System.getenv("OCI_CONFIG_FILE");
        if (envConfigFile == null) {
            throw new IllegalStateException("Current environment is not a Cloud Shell session: The \"OCI_CONFIG_FILE environment variable is not set.");
        }
        return AuthenticationDetailsFactory.configFileAuthentication(envConfigFile, "DEFAULT");
    }

    private static ConfigFileAuthenticationDetailsProvider configFileAuthentication(String filePath, String profile) {
        try {
            if (filePath == null) {
                return new ConfigFileAuthenticationDetailsProvider(profile);
            }
            return new ConfigFileAuthenticationDetailsProvider(filePath, profile);
        }
        catch (IOException ioException) {
            throw AuthenticationDetailsFactory.configFileReadFailure(ioException);
        }
    }

    private static IllegalStateException configFileReadFailure(IOException ioException) {
        return new IllegalStateException("Failed to read an OCI configuration file. See cause for details.", ioException);
    }

    private static AuthenticationDetailsProvider simpleAuthentication(String tenancy, String user, String fingerprint, String privateKey, String passPhrase, Region region) {
        return SimpleAuthenticationDetailsProvider.builder().tenantId(tenancy).userId(user).fingerprint(fingerprint).privateKeySupplier((Supplier)new SimplePrivateKeySupplier(privateKey)).passPhrase(passPhrase).region(region).build();
    }

    private static final class InstancePrincipalAuthenticationTask {
        private static final Future<InstancePrincipalsAuthenticationDetailsProvider> FUTURE = CompletableFuture.supplyAsync(() -> InstancePrincipalsAuthenticationDetailsProvider.builder().build(), runnable -> {
            Thread thread = new Thread(runnable, "ojdbc-provider-oci: Instance Principal Authentication");
            thread.setDaemon(true);
            thread.start();
        });

        private InstancePrincipalAuthenticationTask() {
        }
    }
}

