/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import java.io.IOException;

public class OsonEnumSerializer
extends JsonSerializer<Enum<?>>
implements ContextualSerializer {
    private final boolean isEnumerated;
    private final boolean isEnumeratedString;

    public OsonEnumSerializer(boolean isEnumerated, boolean isEnumeratedString) {
        this.isEnumerated = isEnumerated;
        this.isEnumeratedString = isEnumeratedString;
    }

    public OsonEnumSerializer() {
        this(false, false);
    }

    public void serialize(Enum<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        if (this.isEnumerated && this.isEnumeratedString) {
            gen.writeString(value.name());
            return;
        }
        gen.writeNumber(value.ordinal());
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        Enumerated enumerated;
        AnnotatedMember member;
        boolean isEnumeratedCT = false;
        boolean isEnumeratedStringCT = false;
        if (property != null && (member = property.getMember()) != null && (enumerated = (Enumerated)member.getAnnotation(Enumerated.class)) != null) {
            isEnumeratedCT = true;
            if (enumerated.value() == EnumType.STRING) {
                isEnumeratedStringCT = true;
            }
            return new OsonEnumSerializer(isEnumeratedCT, isEnumeratedStringCT);
        }
        return new OsonEnumSerializer(false, false);
    }
}

