/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import oracle.jdbc.provider.oson.OsonParser;

public class OsonUUIDDeserializer
extends StdScalarDeserializer<UUID> {
    public static final OsonUUIDDeserializer INSTANCE = new OsonUUIDDeserializer();
    public static final UUIDDeserializer UUID_DESERIALIZER = new UUIDDeserializer();

    public OsonUUIDDeserializer() {
        super(UUID.class);
    }

    public UUID deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p instanceof OsonParser && p.currentToken().equals((Object)JsonToken.VALUE_EMBEDDED_OBJECT)) {
            byte[] bytes = p.getBinaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            long mostSignificantBits = byteBuffer.getLong();
            long leastSignificantBits = byteBuffer.getLong();
            return new UUID(mostSignificantBits, leastSignificantBits);
        }
        return (UUID)UUID_DESERIALIZER.deserialize(p, ctxt);
    }
}

