/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import oracle.jdbc.provider.oson.OsonGenerator;

public class OsonOffsetDateTimeSerializer
extends OffsetDateTimeSerializer {
    public static final OsonOffsetDateTimeSerializer INSTANCE = new OsonOffsetDateTimeSerializer();

    public OsonOffsetDateTimeSerializer() {
    }

    protected OsonOffsetDateTimeSerializer(OffsetDateTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter formatter) {
        super(base, useTimestamp, useNanoseconds, formatter);
    }

    public OsonOffsetDateTimeSerializer(OffsetDateTimeSerializer base, Boolean useTimestamp, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, useTimestamp, formatter, shape);
    }

    protected OsonOffsetDateTimeSerializer withFormat(Boolean useTimestamp, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        return new OsonOffsetDateTimeSerializer((OffsetDateTimeSerializer)this, useTimestamp, formatter, shape);
    }

    protected OsonOffsetDateTimeSerializer withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new OsonOffsetDateTimeSerializer((OffsetDateTimeSerializer)this, this._useTimestamp, writeNanoseconds, this._formatter);
    }

    public void serialize(OffsetDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._formatter != null || this._shape != null) {
            super.serialize((Temporal)value, gen, provider);
            return;
        }
        if (gen instanceof OsonGenerator) {
            OsonGenerator _gen = (OsonGenerator)gen;
            _gen.writeOffsetDateTime(value);
        } else {
            super.serialize((Temporal)value, gen, provider);
        }
    }
}

