/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.jsr310.util.DurationUnitConverter;
import java.io.IOException;
import java.time.Duration;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonParser;

public class OsonDurationDeserializer
extends DurationDeserializer {
    public static final OsonDurationDeserializer INSTANCE = new OsonDurationDeserializer();

    protected OsonDurationDeserializer() {
    }

    protected OsonDurationDeserializer(DurationDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected OsonDurationDeserializer(OsonDurationDeserializer base, DurationUnitConverter converter) {
        super((DurationDeserializer)base, Boolean.valueOf(base._isLenient));
    }

    protected OsonDurationDeserializer withLeniency(Boolean leniency) {
        return new OsonDurationDeserializer((DurationDeserializer)this, leniency);
    }

    protected DurationDeserializer withConverter(DurationUnitConverter converter) {
        return new OsonDurationDeserializer(this, converter);
    }

    public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p instanceof OsonParser) {
            OsonParser _parser = (OsonParser)p;
            if (_parser.currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_INTERVALDS)) {
                return _parser.readDuration();
            }
            return super.deserialize(p, ctxt);
        }
        return super.deserialize(p, ctxt);
    }
}

