/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.provider.oson.OsonGenerator;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;

public class OsonFactory
extends JsonFactory {
    private final Logger logger = Logger.getLogger(OsonFactory.class.getName());
    private static final OracleJsonFactory factory = new OracleJsonFactory();

    public JsonGenerator createGenerator(OutputStream out) throws IOException {
        this.logger.log(Level.FINEST, "createGenerator(OutputStream)");
        return this.createGenerator(out, JsonEncoding.UTF8);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        this.logger.log(Level.FINEST, "createGenerator(OutputStream, JsonEncoding)");
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        OsonGenerator g = new OsonGenerator(this._generatorFeatures, null, factory.createJsonBinaryGenerator(out), out);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        if (this._characterEscapes != null) {
            g.setCharacterEscapes(this._characterEscapes);
        }
        return g;
    }

    public JsonGenerator createGenerator(Writer out) throws IOException {
        this.logger.log(Level.FINEST, "createGenerator(Writer)");
        IOContext ctxt = this._createContext(this._createContentReference(out), true);
        OsonGenerator g = new OsonGenerator(this._generatorFeatures, null, factory.createJsonTextGenerator(this._decorate(out, ctxt)));
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        if (this._characterEscapes != null) {
            g.setCharacterEscapes(this._characterEscapes);
        }
        return g;
    }

    public JsonGenerator createGenerator(DataOutput out) throws IOException {
        this.logger.log(Level.FINEST, "createGenerator(DataOutput)");
        return this.createGenerator((OutputStream)((Object)out), JsonEncoding.UTF8);
    }

    public JsonGenerator createGenerator(DataOutput out, JsonEncoding enc) throws IOException {
        this.logger.log(Level.FINEST, "createGenerator(DataOutput, JsonEncoding)");
        return this.createGenerator((OutputStream)((Object)out), enc);
    }

    public JsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        this.logger.log(Level.FINEST, "createGenerator(File, JsonEncoding)");
        OutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8 && this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this.createGenerator(out, enc);
    }

    public JsonGenerator createGenerator(OracleJsonGenerator oGen) {
        this.logger.log(Level.FINEST, "createGenerator(OracleJsonGenerator)");
        OsonGenerator g = new OsonGenerator(this._generatorFeatures, null, oGen);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        if (this._characterEscapes != null) {
            g.setCharacterEscapes(this._characterEscapes);
        }
        return g;
    }

    public JsonParser createParser(byte[] data) {
        this.logger.log(Level.FINEST, "createParser(byte[])");
        IOContext ctxt = this._createContext(data, true);
        return this._createParser(data, 0, data.length, ctxt);
    }

    public JsonParser createParser(char[] content) {
        this.logger.log(Level.FINEST, "createParser(char[])");
        IOContext ctxt = this._createContext(content, true);
        return this._createParser(content, 0, content.length, ctxt, false);
    }

    public JsonParser createParser(File f) throws IOException {
        this.logger.log(Level.FINEST, "createParser(File)");
        IOContext ctxt = this._createContext(f, true);
        InputStream in = new FileInputStream(f);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    public JsonParser createParser(Reader r) throws IOException {
        this.logger.log(Level.FINEST, "createParser(Reader)");
        IOContext ctxt = this._createContext(r, true);
        return this._createParser(this._decorate(r, ctxt), ctxt);
    }

    public JsonParser createParser(InputStream in) throws IOException {
        this.logger.log(Level.FINEST, "createParser(InputStream)");
        IOContext ctxt = this._createContext(in, true);
        return this._createParser(this._decorate(in, ctxt), ctxt);
    }

    public JsonParser createParser(String content) throws IOException {
        this.logger.log(Level.FINEST, "createParser(String)");
        IOContext ctxt = this._createContext(content, true);
        return this._createParser(content.toCharArray(), 0, content.length(), ctxt, false);
    }

    public JsonParser createParser(URL url) throws IOException {
        this.logger.log(Level.FINEST, "createParser(URL)");
        IOContext ctxt = this._createContext(url, true);
        InputStream in = this._optimizedStreamFromURL(url);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    public JsonParser createParser(byte[] data, int offset, int len) throws IOException {
        InputStream in;
        this.logger.log(Level.FINEST, "createParser(byte[], int, int)");
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, offset, len)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    public JsonParser createParser(char[] content, int offset, int len) throws IOException {
        this.logger.log(Level.FINEST, "createParser(char[], int, int)");
        IOContext ctxt = this._createContext(content, true);
        Reader r = new CharArrayReader(content, offset, len);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    public JsonParser _createParser(InputStream in, IOContext ctxt) {
        this.logger.log(Level.FINEST, "_createParser(InputStream)");
        return new OsonParser(ctxt, this._factoryFeatures, factory.createJsonBinaryParser(in));
    }

    public JsonParser _createParser(Reader r, IOContext ctxt) {
        this.logger.log(Level.FINEST, "_createParser(Reader)");
        return new OsonParser(ctxt, this._factoryFeatures, factory.createJsonTextParser(r));
    }

    public JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) {
        this.logger.log(Level.FINEST, "_createParser(char[], int, int, IOContext)");
        return new OsonParser(ctxt, this._factoryFeatures, factory.createJsonTextParser((Reader)new CharArrayReader(data, offset, len)));
    }

    public JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) {
        this.logger.log(Level.FINEST, "_createParser(byte[], int, int, IOContext)");
        return new OsonParser(ctxt, this._factoryFeatures, factory.createJsonBinaryParser(ByteBuffer.wrap(data, offset, len)));
    }

    public JsonParser createParser(OracleJsonParser oParser) {
        this.logger.log(Level.FINEST, "createParser(OracleJsonParser)");
        return new OsonParser(this._createContext(null, false), this._factoryFeatures, oParser);
    }

    protected JsonParser _createParser(final DataInput input, IOContext ctxt) {
        this.logger.log(Level.FINEST, "_createParser(DataInput, IOContext)");
        InputStream stream = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    return input.readUnsignedByte();
                }
                catch (EOFException e) {
                    return -1;
                }
            }
        };
        return new OsonParser(ctxt, this._factoryFeatures, factory.createJsonBinaryParser(stream));
    }
}

