/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.gcp.secrets;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.Secret;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretName;
import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public class GcpSecretManagerFactory
implements ResourceFactory<SecretPayload> {
    public static final Parameter<String> SECRET_VERSION_NAME = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<SecretPayload> INSTANCE = CachedResourceFactory.create((ResourceFactory)new GcpSecretManagerFactory());

    private GcpSecretManagerFactory() {
    }

    public static ResourceFactory<SecretPayload> getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resource<SecretPayload> request(ParameterSet parameterSet) throws IllegalStateException, IllegalArgumentException {
        String paramerter = (String)parameterSet.getRequired(SECRET_VERSION_NAME);
        try (SecretManagerServiceClient client = SecretManagerServiceClient.create();){
            SecretVersionName secretVersionName = SecretVersionName.parse((String)paramerter);
            SecretName secretName = SecretName.of((String)secretVersionName.getProject(), (String)secretVersionName.getSecret());
            Secret secret = client.getSecret(secretName);
            AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
            if (secret.hasExpireTime()) {
                OffsetDateTime expireTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(secret.getExpireTime().getNanos() * 1000000), ZoneId.systemDefault());
                Resource resource2 = Resource.createExpiringResource((Object)response.getPayload(), (OffsetDateTime)expireTime, (boolean)true);
                return resource2;
            }
            Resource resource = Resource.createPermanentResource((Object)response.getPayload(), (boolean)true);
            return resource;
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }
}

