/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.gcp.resource;

import java.util.Map;
import oracle.jdbc.provider.gcp.resource.GcpSecretManagerProvider;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.FileUtils;
import oracle.jdbc.provider.util.WalletUtils;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.PasswordProvider;
import oracle.jdbc.spi.UsernameProvider;

public class GcpSecretManagerSEPSProvider
extends GcpSecretManagerProvider
implements UsernameProvider,
PasswordProvider {
    private static final ResourceParameter[] SEPS_PARAMETERS = new ResourceParameter[]{new ResourceParameter("walletPassword", CommonParameters.PASSWORD), new ResourceParameter("connectionStringIndex", CommonParameters.CONNECTION_STRING_INDEX)};

    public GcpSecretManagerSEPSProvider() {
        super("secretmanager-seps", SEPS_PARAMETERS);
    }

    public String getUsername(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.getWalletCredentials(parameterValues).username();
    }

    public char[] getPassword(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.getWalletCredentials(parameterValues).password();
    }

    private WalletUtils.Credentials getWalletCredentials(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        ParameterSet parameterSet = this.parseParameterValues(parameterValues);
        byte[] walletBytes = FileUtils.decodeIfBase64((byte[])this.getSecret(parameterValues).toByteArray());
        char[] walletPassword = parameterSet.getOptional(CommonParameters.PASSWORD) != null ? ((String)parameterSet.getOptional(CommonParameters.PASSWORD)).toCharArray() : null;
        String connectionStringIndex = (String)parameterSet.getOptional(CommonParameters.CONNECTION_STRING_INDEX);
        return WalletUtils.getCredentials((byte[])walletBytes, (char[])walletPassword, (String)connectionStringIndex);
    }
}

