/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.gcp.resource;

import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.protobuf.ByteString;
import java.util.Map;
import oracle.jdbc.provider.gcp.secrets.GcpSecretManagerFactory;
import oracle.jdbc.provider.resource.AbstractResourceProvider;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.ResourceParameterUtils;
import oracle.jdbc.spi.OracleResourceProvider;

class GcpSecretManagerProvider
extends AbstractResourceProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("secretVersionName", GcpSecretManagerFactory.SECRET_VERSION_NAME)};

    protected GcpSecretManagerProvider(String valueType) {
        super("gcp", valueType, PARAMETERS);
    }

    public GcpSecretManagerProvider(String valueType, ResourceParameter[] additionalParameters) {
        super("gcp", valueType, ResourceParameterUtils.combineParameters((ResourceParameter[])PARAMETERS, (ResourceParameter[])additionalParameters));
    }

    protected final ByteString getSecret(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return ((SecretPayload)this.getResource(GcpSecretManagerFactory.getInstance(), parameterValues)).getData();
    }
}

