/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.gcp.objectstorage;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public class GcpCloudStorageFactory
implements ResourceFactory<InputStream> {
    public static final Parameter<String> PROJECT = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    public static final Parameter<String> BUCKET = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    public static final Parameter<String> OBJECT = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<InputStream> INSTANCE = CachedResourceFactory.create((ResourceFactory)new GcpCloudStorageFactory());

    private GcpCloudStorageFactory() {
    }

    public static ResourceFactory<InputStream> getInstance() {
        return INSTANCE;
    }

    public Resource<InputStream> request(ParameterSet parameterSet) throws IllegalStateException, IllegalArgumentException {
        String projectName = (String)parameterSet.getRequired(PROJECT);
        String bucketName = (String)parameterSet.getRequired(BUCKET);
        String objectName = (String)parameterSet.getRequired(OBJECT);
        Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectName)).build().getService();
        byte[] data = storage.readAllBytes(bucketName, objectName, new Storage.BlobSourceOption[0]);
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        return Resource.createPermanentResource((Object)stream, (boolean)false);
    }
}

