/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.gcp.configuration;

import com.google.cloud.secretmanager.v1.SecretPayload;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.driver.configuration.OracleConfigurationParsableProvider;
import oracle.jdbc.provider.gcp.configuration.GcpConfigurationParameters;
import oracle.jdbc.provider.gcp.secrets.GcpSecretManagerFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.util.OracleConfigurationCache;

public class GcpSecretManagerConfigurationProvider
extends OracleConfigurationParsableProvider {
    public String getType() {
        return "gcpsecretmanager";
    }

    public InputStream getInputStream(String location) throws SQLException {
        HashMap<String, String> namedValues = new HashMap<String, String>();
        namedValues.put("secretVersionName", location);
        ParameterSet parameterSet = GcpConfigurationParameters.getParser().parseNamedValues(namedValues);
        return new ByteArrayInputStream(((SecretPayload)GcpSecretManagerFactory.getInstance().request(parameterSet).getContent()).getData().toByteArray());
    }

    public OracleConfigurationCache getCache() {
        return CACHE;
    }

    public String getParserType(String arg0) {
        return "json";
    }
}

