/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.gcp.configuration;

import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.protobuf.ByteString;
import java.util.Base64;
import java.util.Map;
import oracle.jdbc.provider.gcp.configuration.GcpConfigurationParameters;
import oracle.jdbc.provider.gcp.secrets.GcpSecretManagerFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.spi.OracleConfigurationSecretProvider;

public class GcpJsonSecretManagerProvider
implements OracleConfigurationSecretProvider {
    public char[] getSecret(Map<String, String> secretProperties) {
        ParameterSet parameterSet = GcpConfigurationParameters.getParser().parseNamedValues(secretProperties);
        ByteString stringData = ((SecretPayload)GcpSecretManagerFactory.getInstance().request(parameterSet).getContent()).getData();
        return Base64.getEncoder().encodeToString(stringData.toByteArray()).toCharArray();
    }

    public String getSecretType() {
        return "gcpsecretmanager";
    }
}

