/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.gcp.configuration;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.driver.configuration.OracleConfigurationParsableProvider;
import oracle.jdbc.provider.gcp.configuration.GcpConfigurationParameters;
import oracle.jdbc.provider.gcp.objectstorage.GcpCloudStorageFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.util.OracleConfigurationCache;

public class GcpCloudStorageConfigurationProvider
extends OracleConfigurationParsableProvider {
    public static final String PROJECT_PARAMETER = "project";
    public static final String BUCKET_PARAMETER = "bucket";
    public static final String OBJECT_PARAMETER = "object";

    public String getType() {
        return "gcpstorage";
    }

    public InputStream getInputStream(String location) throws SQLException {
        String[] keyValuePairs;
        HashMap<String, String> namedValues = new HashMap<String, String>();
        for (String keyValuePair : keyValuePairs = location.split(";")) {
            String[] keyValue = keyValuePair.split("=", 2);
            namedValues.putIfAbsent(keyValue[0], keyValue[1]);
        }
        ParameterSet parameterSet = GcpConfigurationParameters.getParser().parseNamedValues(namedValues);
        return (InputStream)GcpCloudStorageFactory.getInstance().request(parameterSet).getContent();
    }

    public OracleConfigurationCache getCache() {
        return CACHE;
    }
}

