/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.parameter;

import java.util.Collections;
import java.util.Map;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;
import oracle.jdbc.provider.parameter.ParameterSetBuilderImpl;
import oracle.jdbc.provider.parameter.ParameterSetImpl;

public interface ParameterSet {
    public static ParameterSet empty() {
        return new ParameterSetImpl(Collections.emptyMap(), Collections.emptyMap());
    }

    public static ParameterSetBuilder builder() {
        return new ParameterSetBuilderImpl();
    }

    public boolean contains(Parameter<?> var1);

    public <T> T getOptional(Parameter<T> var1);

    public String getName(Parameter<?> var1);

    default public <T> T getRequired(Parameter<T> parameter) throws IllegalStateException {
        T value = this.getOptional(parameter);
        if (value != null) {
            return value;
        }
        String name = this.getName(parameter);
        throw new IllegalStateException(String.format("No value defined for parameter \"%s\"", name != null ? name : parameter.toString()));
    }

    public ParameterSetBuilder copyBuilder();

    public Map<String, Object> filterParameters(String[] var1);
}

