/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import oracle.jdbc.provider.util.PemData;
import oracle.security.pki.OraclePKIProvider;

public final class TlsUtils {
    private static final String PEM_KEYSTORE_TYPE = "PEM";

    private TlsUtils() {
    }

    public static KeyStore loadKeyStore(InputStream inputStream, char[] password, String type, Provider provider) {
        try {
            KeyStore keyStore = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            keyStore.load(inputStream, password);
            return keyStore;
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new IllegalStateException("Failed to load KeyStore", exception);
        }
    }

    public static KeyStore createPEMKeyStore(byte[] fileBytes, char[] password) throws Exception {
        List<PemData> pemDataList = PemData.decode(new ByteArrayInputStream(fileBytes));
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        PrivateKey privateKey = null;
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        block5: for (PemData pemData : pemDataList) {
            switch (pemData.label()) {
                case PRIVATE_KEY: {
                    PKCS8EncodedKeySpec pkcs8 = new PKCS8EncodedKeySpec(pemData.data());
                    privateKey = KeyFactory.getInstance("RSA").generatePrivate(pkcs8);
                    continue block5;
                }
                case ENCRYPTED_PRIVATE_KEY: {
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(pemData.data());
                    PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
                    SecretKey secretKey = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName()).generateSecret(pbeKeySpec);
                    privateKey = KeyFactory.getInstance("RSA").generatePrivate(encryptedPrivateKeyInfo.getKeySpec(secretKey));
                    continue block5;
                }
                case CERTIFICATE: {
                    Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(pemData.data()));
                    certificates.add(certificate);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unsupported PEM data label: " + (Object)((Object)pemData.label()));
        }
        if (privateKey == null || certificates.isEmpty()) {
            throw new IllegalStateException("Missing private key or certificates in PEM data");
        }
        keyStore.setKeyEntry("key", privateKey, password, certificates.toArray(new Certificate[0]));
        return keyStore;
    }

    public static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore, char[] password) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Failed initialize SSLContext", generalSecurityException);
        }
    }

    public static SSLContext createSSLContext(byte[] fileBytes, char[] password, String type) throws Exception {
        KeyStore keyStore = PEM_KEYSTORE_TYPE.equalsIgnoreCase(type) ? TlsUtils.createPEMKeyStore(fileBytes, password) : TlsUtils.loadKeyStore(fileBytes, password, type);
        return TlsUtils.createSSLContext(keyStore, keyStore, password);
    }

    static KeyStore loadKeyStore(byte[] fileBytes, char[] password, String type) throws IOException {
        try (ByteArrayInputStream fileStream = new ByteArrayInputStream(fileBytes);){
            KeyStore keyStore = TlsUtils.loadKeyStore(fileStream, password, type, (Provider)new OraclePKIProvider());
            return keyStore;
        }
    }
}

