/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class TNSNames {
    private static final int MAX_CONNECTION_STRING_SIZE = 4000;
    private final Map<ConsumerGroup, String> connectionStrings;
    private final Map<String, String> aliasConnectionStrings;

    private TNSNames(Map<ConsumerGroup, String> connectionStrings, Map<String, String> aliasConnectionStrings) {
        this.connectionStrings = connectionStrings;
        this.aliasConnectionStrings = aliasConnectionStrings;
    }

    public String getConnectionString(ConsumerGroup consumerGroup) {
        return this.connectionStrings.get((Object)consumerGroup);
    }

    public String getConnectionStringByAlias(String alias) {
        return this.aliasConnectionStrings.get(alias);
    }

    public static TNSNames read(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        EnumMap<ConsumerGroup, String> connectionStrings = new EnumMap<ConsumerGroup, String>(ConsumerGroup.class);
        HashMap<String, String> aliasConnectionStrings = new HashMap<String, String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (TNSNames.isParameterStart(line)) {
                    int serviceNameEnd = line.indexOf(32);
                    String serviceName = line.substring(0, serviceNameEnd);
                    ConsumerGroup consumerGroup = ConsumerGroup.fromServiceName(serviceName);
                    String descriptor = TNSNames.parseDescriptor(line, reader);
                    connectionStrings.put(consumerGroup, descriptor);
                    aliasConnectionStrings.put(serviceName, descriptor);
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failed to read tnsnames.ora", ioException);
        }
        return new TNSNames(connectionStrings, aliasConnectionStrings);
    }

    private static boolean isParameterStart(String line) {
        if (line.isEmpty()) {
            return false;
        }
        char firstChar = line.charAt(0);
        return firstChar != ' ' && firstChar != '\t' && firstChar != '#';
    }

    private static String parseDescriptor(String firstLine, BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        int descriptorStart = firstLine.indexOf(61) + 1;
        if (descriptorStart < firstLine.length()) {
            builder.append(firstLine.substring(descriptorStart));
        }
        while (true) {
            reader.mark(4000);
            String line = reader.readLine();
            if (line == null) break;
            if (TNSNames.isParameterStart(line)) {
                reader.reset();
                break;
            }
            int size = builder.length() + line.length();
            if (size > 4000) {
                throw new IllegalStateException(String.format("Size of a connection string is at least %,d bytes, and exceeds the maximum size of %d bytes", size, 4000));
            }
            builder.append(line);
        }
        return builder.toString();
    }

    public static enum ConsumerGroup {
        HIGH("high"),
        MEDIUM("medium"),
        LOW("low"),
        TRANSACTION_PROCESSING("tp"),
        TRANSACTION_PROCESSING_URGENT("tpurgent");

        private final String postFix;
        private static final Map<String, ConsumerGroup> POST_FIX_MAP;

        private ConsumerGroup(String postFix) {
            this.postFix = postFix;
        }

        static ConsumerGroup fromServiceName(String serviceName) {
            int postFixStart = 1 + serviceName.lastIndexOf(95);
            if (postFixStart > serviceName.length() - 1) {
                throw ConsumerGroup.unrecognizedConsumerGroup(serviceName);
            }
            String postFix = serviceName.substring(postFixStart);
            ConsumerGroup consumerGroup = POST_FIX_MAP.get(postFix);
            if (consumerGroup == null) {
                throw ConsumerGroup.unrecognizedConsumerGroup(serviceName);
            }
            return consumerGroup;
        }

        private static IllegalStateException unrecognizedConsumerGroup(String serviceName) {
            return new IllegalStateException("Consumer group is not recognized in service name: " + serviceName);
        }

        static {
            ConsumerGroup[] consumerGroups = ConsumerGroup.values();
            HashMap<String, ConsumerGroup> postFixMap = new HashMap<String, ConsumerGroup>(consumerGroups.length);
            for (ConsumerGroup consumerGroup : consumerGroups) {
                postFixMap.put(consumerGroup.postFix, consumerGroup);
            }
            POST_FIX_MAP = Collections.unmodifiableMap(postFixMap);
        }
    }
}

