/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonValue;

public class JsonWebTokenParser {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
    private static final int MAX_JWT_SIZE = 16000;

    private JsonWebTokenParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parseClaims(Path filePath) {
        int bufferSize;
        try {
            bufferSize = JsonWebTokenParser.requireValidSize(Files.size(filePath));
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException(ioException);
        }
        char[] jwt = new char[bufferSize];
        try {
            CharBuffer buffer = CharBuffer.wrap(jwt);
            try (BufferedReader reader = Files.newBufferedReader(filePath);){
                while (reader.read(buffer) != -1 && buffer.hasRemaining()) {
                }
            }
            catch (IOException ioException) {
                throw new IllegalArgumentException("Failed to read " + filePath, ioException);
            }
            buffer.flip();
            Map<String, String> map = JsonWebTokenParser.parseClaims(buffer);
            return map;
        }
        finally {
            Arrays.fill(jwt, '\u0000');
        }
    }

    public static Map<String, String> parseClaims(CharSequence jwt) {
        Map<String, String> map;
        Objects.requireNonNull(jwt, "jwt is null");
        JsonWebTokenParser.requireValidSize(jwt.length());
        InputStream base64Stream = Base64.getDecoder().wrap(new PayloadInputStream(jwt));
        InputStreamReader payloadReader = new InputStreamReader(base64Stream, StandardCharsets.UTF_8);
        try {
            map = JSON_FACTORY.createJsonTextValue((Reader)payloadReader).asJsonObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonWebTokenParser.toString((OracleJsonValue)entry.getValue())));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)payloadReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                throw new IllegalArgumentException("Failed to read JWT", ioException);
            }
        }
        ((Reader)payloadReader).close();
        return map;
    }

    public static OffsetDateTime parseExp(CharSequence jwt) {
        Map<String, String> claims = JsonWebTokenParser.parseClaims(jwt);
        String exp = claims.get("exp");
        if (exp == null) {
            return OffsetDateTime.MAX;
        }
        return Instant.ofEpochSecond(Long.parseLong(exp)).atOffset(ZoneOffset.UTC);
    }

    private static String toString(OracleJsonValue oracleJsonValue) {
        switch (oracleJsonValue.getOracleJsonType()) {
            case STRING: {
                return oracleJsonValue.asJsonString().getString();
            }
        }
        return oracleJsonValue.toString();
    }

    private static int requireValidSize(long size) {
        if (size > 16000L) {
            throw new IllegalArgumentException(String.format("JWT exceeds maximum size of %d bytes", 16000));
        }
        return (int)size;
    }

    private static IllegalArgumentException invalidSyntax() {
        return new IllegalArgumentException("JWT does not match expected syntax: {header}.{payload}.[signature]");
    }

    private static final class PayloadInputStream
    extends InputStream {
        private final CharBuffer payloadBuffer;

        PayloadInputStream(CharSequence jwt) {
            int headerEnd = PayloadInputStream.indexOf('.', 0, jwt);
            if (headerEnd == -1) {
                throw JsonWebTokenParser.invalidSyntax();
            }
            int payloadEnd = PayloadInputStream.indexOf('.', headerEnd + 1, jwt);
            if (payloadEnd == -1) {
                throw JsonWebTokenParser.invalidSyntax();
            }
            this.payloadBuffer = CharBuffer.wrap(jwt, headerEnd + 1, payloadEnd);
        }

        @Override
        public int read() throws IOException {
            return this.payloadBuffer.hasRemaining() ? this.payloadBuffer.get() & 0xFF : -1;
        }

        private static int indexOf(char charValue, int fromIndex, CharSequence charSequence) {
            for (int i = fromIndex; i < charSequence.length(); ++i) {
                if (charSequence.charAt(i) != charValue) continue;
                return i;
            }
            return -1;
        }
    }
}

