/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oauth;

import java.util.function.Supplier;
import oracle.jdbc.AccessToken;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public final class AccessTokenCacheFactory
implements ResourceFactory<Supplier<? extends AccessToken>> {
    public static final Parameter<ResourceFactory<AccessToken>> FACTORY = Parameter.create(Parameter.CommonAttribute.REQUIRED);
    private static final ResourceFactory<Supplier<? extends AccessToken>> INSTANCE = CachedResourceFactory.create(new AccessTokenCacheFactory());

    private AccessTokenCacheFactory() {
    }

    public static ResourceFactory<Supplier<? extends AccessToken>> getInstance() {
        return INSTANCE;
    }

    @Override
    public Resource<Supplier<? extends AccessToken>> request(ParameterSet parameterSet) {
        ResourceFactory<AccessToken> factory = parameterSet.getRequired(FACTORY);
        Supplier accessTokenCache = AccessToken.createJsonWebTokenCache(() -> (AccessToken)factory.request(parameterSet).getContent());
        return Resource.createPermanentResource(accessTokenCache, false);
    }
}

