/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.configuration;

import java.util.HashMap;
import java.util.Map;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public final class JsonSecretUtil {
    private JsonSecretUtil() {
    }

    public static Map<String, String> toNamedValues(OracleJsonObject secretJsonObject) {
        String valueFieldName = "value";
        HashMap<String, String> options = new HashMap<String, String>();
        if (secretJsonObject.containsKey((Object)"value")) {
            OracleJsonValue secretUri = (OracleJsonValue)secretJsonObject.get((Object)"value");
            if (secretUri.getOracleJsonType().equals((Object)OracleJsonValue.OracleJsonType.STRING)) {
                options.put("value", secretUri.asJsonString().getString());
            } else {
                options.put("value", secretUri.toString());
            }
        }
        if (secretJsonObject.containsKey((Object)"authentication")) {
            OracleJsonObject authenticationJsonObject = ((OracleJsonValue)secretJsonObject.get((Object)"authentication")).asJsonObject();
            if (authenticationJsonObject.containsKey((Object)"method")) {
                OracleJsonValue authentication = (OracleJsonValue)authenticationJsonObject.get((Object)"method");
                authenticationJsonObject.remove((Object)"method");
                authenticationJsonObject.put((Object)"AUTHENTICATION", (Object)authentication);
            }
            authenticationJsonObject.forEach((key, value) -> {
                if (value.getOracleJsonType().equals((Object)OracleJsonValue.OracleJsonType.STRING)) {
                    options.put((String)key, value.asJsonString().getString());
                } else {
                    options.put((String)key, value.toString());
                }
            });
        }
        return options;
    }
}

