/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.resource;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.spi.OracleResourceProvider;

public final class ResourceParameter
implements OracleResourceProvider.Parameter {
    private final String name;
    private final String defaultValue;
    private final boolean isSensitive;
    private final boolean isRequired;
    private final Consumer<ParameterSetBuilder> defaultValueSetter;
    private final BiConsumer<String, ParameterSetBuilder> parser;

    public ResourceParameter(String name, Parameter<String> providerParameter) {
        this(name, providerParameter, null);
    }

    public ResourceParameter(String name, Parameter<String> providerParameter, String defaultValue) {
        this(name, defaultValue, providerParameter.isRequired(), providerParameter.isSensitive(), defaultValue == null ? builder -> {} : builder -> builder.add(name, providerParameter, defaultValue), (value, builder) -> builder.add(name, providerParameter, value));
    }

    public <T> ResourceParameter(String name, Parameter<T> providerParameter, String defaultValue, Function<String, T> parser) {
        this(name, defaultValue, providerParameter.isRequired(), providerParameter.isSensitive(), defaultValue == null ? builder -> {} : builder -> builder.add(name, providerParameter, parser.apply(defaultValue)), (value, builder) -> builder.add(name, providerParameter, parser.apply((String)value)));
    }

    public ResourceParameter(String name, String defaultValue, boolean isRequired, boolean isSensitive, Consumer<ParameterSetBuilder> defaultValueSetter, BiConsumer<String, ParameterSetBuilder> parser) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
        this.isSensitive = isSensitive;
        this.defaultValueSetter = defaultValueSetter;
        this.parser = parser;
    }

    public String name() {
        return this.name;
    }

    public boolean isSensitive() {
        return this.isSensitive;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public CharSequence defaultValue() {
        return this.defaultValue;
    }

    void configureParser(ParameterSetParser.Builder builder) {
        builder.addParameter(this.name, this.defaultValueSetter, this.parser);
    }
}

