/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.keyvault;

import com.azure.core.credential.TokenCredential;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.time.OffsetDateTime;
import oracle.jdbc.provider.azure.AzureResourceFactory;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public final class KeyVaultSecretFactory
extends AzureResourceFactory<KeyVaultSecret> {
    public static final Parameter<String> VAULT_URL = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    public static final Parameter<String> SECRET_NAME = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<KeyVaultSecret> INSTANCE = CachedResourceFactory.create((ResourceFactory)new KeyVaultSecretFactory());

    private KeyVaultSecretFactory() {
    }

    public static ResourceFactory<KeyVaultSecret> getInstance() {
        return INSTANCE;
    }

    @Override
    public Resource<KeyVaultSecret> request(TokenCredential tokenCredential, ParameterSet parameterSet) {
        String vaultUri = (String)parameterSet.getRequired(VAULT_URL);
        String secretName = (String)parameterSet.getRequired(SECRET_NAME);
        SecretClient secretClient = new SecretClientBuilder().credential(tokenCredential).vaultUrl(vaultUri).buildClient();
        KeyVaultSecret keyVaultSecret = secretClient.getSecret(secretName);
        OffsetDateTime expireTime = keyVaultSecret.getProperties().getExpiresOn();
        if (expireTime == null) {
            return Resource.createPermanentResource((Object)keyVaultSecret, (boolean)true);
        }
        return Resource.createExpiringResource((Object)keyVaultSecret, (OffsetDateTime)expireTime, (boolean)true);
    }
}

