/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.resource;

import java.util.Base64;
import java.util.Map;
import javax.net.ssl.SSLContext;
import oracle.jdbc.provider.azure.resource.KeyVaultSecretProvider;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.TlsUtils;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.TlsConfigurationProvider;

public class KeyVaultTCPSProvider
extends KeyVaultSecretProvider
implements TlsConfigurationProvider {
    private static final ResourceParameter[] TCPS_PARAMETERS = new ResourceParameter[]{new ResourceParameter("walletPassword", CommonParameters.PASSWORD), new ResourceParameter("type", CommonParameters.TYPE)};

    public KeyVaultTCPSProvider() {
        super("key-vault-tls", TCPS_PARAMETERS);
    }

    public SSLContext getSSLContext(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        try {
            ParameterSet parameterSet = this.parseParameterValues(parameterValues);
            String secretValue = this.getSecret(parameterValues);
            byte[] fileBytes = Base64.getDecoder().decode(secretValue);
            char[] password = parameterSet.getOptional(CommonParameters.PASSWORD) != null ? ((String)parameterSet.getOptional(CommonParameters.PASSWORD)).toCharArray() : null;
            String type = (String)parameterSet.getRequired(CommonParameters.TYPE);
            return TlsUtils.createSSLContext((byte[])fileBytes, (char[])password, (String)type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create SSLContext from the file", e);
        }
    }
}

