/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import oracle.jdbc.provider.azure.resource.KeyVaultSecretProvider;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.TNSNames;
import oracle.jdbc.spi.ConnectionStringProvider;
import oracle.jdbc.spi.OracleResourceProvider;

public class KeyVaultConnectionStringProvider
extends KeyVaultSecretProvider
implements ConnectionStringProvider {
    private static final ResourceParameter[] TNS_NAMES_PARAMETERS = new ResourceParameter[]{new ResourceParameter("tnsAlias", CommonParameters.TNS_ALIAS)};

    public KeyVaultConnectionStringProvider() {
        super("key-vault-tnsnames", TNS_NAMES_PARAMETERS);
    }

    public String getConnectionString(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        TNSNames tnsNames;
        String alias;
        try {
            alias = (String)this.parseParameterValues(parameterValues).getRequired(CommonParameters.TNS_ALIAS);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Required parameter 'tnsAlias' is missing", e);
        }
        String secretValue = this.getSecret(parameterValues);
        byte[] fileBytes = Base64.getDecoder().decode(secretValue);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);){
            tnsNames = TNSNames.read((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read tnsnames.ora content", e);
        }
        String connectionString = tnsNames.getConnectionStringByAlias(alias);
        if (connectionString == null) {
            throw new IllegalArgumentException("Alias specified does not exist in tnsnames.ora: " + alias);
        }
        return connectionString;
    }
}

