/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.configuration;

import oracle.jdbc.provider.azure.authentication.AzureAuthenticationMethod;
import oracle.jdbc.provider.azure.authentication.TokenCredentialFactory;
import oracle.jdbc.provider.parameter.ParameterSetParser;

public final class AzureConfigurationParameters {
    private AzureConfigurationParameters() {
    }

    static ParameterSetParser.Builder configureBuilder(ParameterSetParser.Builder builder) {
        return builder.addParameter("AUTHENTICATION", TokenCredentialFactory.AUTHENTICATION_METHOD, (Object)AzureAuthenticationMethod.DEFAULT, AzureConfigurationParameters::parseAuthentication).addParameter("AZURE_CLIENT_ID", TokenCredentialFactory.CLIENT_ID).addParameter("AZURE_TENANT_ID", TokenCredentialFactory.TENANT_ID).addParameter("AZURE_CLIENT_SECRET", TokenCredentialFactory.CLIENT_SECRET).addParameter("AZURE_CLIENT_CERTIFICATE_PATH", TokenCredentialFactory.CLIENT_CERTIFICATE_PATH).addParameter("AZURE_CLIENT_CERTIFICATE_PASSWORD", TokenCredentialFactory.CLIENT_CERTIFICATE_PASSWORD).addParameter("AZURE_REDIRECT_URL", TokenCredentialFactory.REDIRECT_URL);
    }

    private static AzureAuthenticationMethod parseAuthentication(String authentication) {
        switch (authentication) {
            case "AZURE_DEFAULT": {
                return AzureAuthenticationMethod.DEFAULT;
            }
            case "AZURE_SERVICE_PRINCIPAL": {
                return AzureAuthenticationMethod.SERVICE_PRINCIPLE;
            }
            case "AZURE_MANAGED_IDENTITY": {
                return AzureAuthenticationMethod.MANAGED_IDENTITY;
            }
            case "AZURE_INTERACTIVE": {
                return AzureAuthenticationMethod.INTERACTIVE;
            }
        }
        throw new IllegalArgumentException("Unrecognized value: " + authentication);
    }
}

