/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.configuration;

import com.azure.core.util.UrlBuilder;
import oracle.jdbc.provider.azure.configuration.AzureConfigurationParameters;
import oracle.jdbc.provider.azure.keyvault.KeyVaultSecretFactory;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;
import oracle.jdbc.provider.parameter.ParameterSetParser;

public class AzureVaultURLParser {
    public static final ParameterSetParser PARAMETER_SET_PARSER = AzureConfigurationParameters.configureBuilder(ParameterSetParser.builder().addParameter("value", AzureVaultURLParser::parseVaultSecretUri)).build();

    private static void parseVaultSecretUri(String vaultSecretUri, ParameterSetBuilder builder) {
        UrlBuilder urlBuilder = UrlBuilder.parse((String)vaultSecretUri);
        String vaultUrl = "https://" + urlBuilder.getHost();
        builder.add("value", KeyVaultSecretFactory.VAULT_URL, (Object)vaultUrl);
        String path = urlBuilder.getPath();
        if (!path.contains("/secrets")) {
            throw new IllegalArgumentException("The Vault Secret URI should contain \"/secrets\" following by the name of the Secret: " + vaultSecretUri);
        }
        String secretName = path.replace("/secrets", "");
        builder.add("value", KeyVaultSecretFactory.SECRET_NAME, (Object)secretName);
    }
}

