/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.configuration;

import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.util.Base64;
import oracle.jdbc.provider.azure.configuration.AzureVaultURLParser;
import oracle.jdbc.provider.azure.keyvault.KeyVaultSecretFactory;
import oracle.jdbc.provider.configuration.JsonSecretUtil;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.spi.OracleConfigurationJsonSecretProvider;
import oracle.sql.json.OracleJsonObject;

public final class AzureVaultSecretProvider
implements OracleConfigurationJsonSecretProvider {
    public char[] getSecret(OracleJsonObject secretJsonObject) {
        ParameterSet parameterSet = AzureVaultURLParser.PARAMETER_SET_PARSER.parseNamedValues(JsonSecretUtil.toNamedValues((OracleJsonObject)secretJsonObject));
        String secretString = ((KeyVaultSecret)KeyVaultSecretFactory.getInstance().request(parameterSet).getContent()).getValue();
        return Base64.getEncoder().encodeToString(secretString.getBytes()).toCharArray();
    }

    public String getSecretType() {
        return "azurevault";
    }
}

