/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.configuration;

import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import oracle.jdbc.driver.OracleConfigurationJsonProvider;
import oracle.jdbc.provider.azure.configuration.AzureVaultURLParser;
import oracle.jdbc.provider.azure.keyvault.KeyVaultSecretFactory;
import oracle.jdbc.provider.parameter.ParameterSet;

public class AzureVaultJsonProvider
extends OracleConfigurationJsonProvider {
    public InputStream getJson(String secretIdentifier) {
        String valueFieldName = "value";
        HashMap<String, String> optionsWithSecret = new HashMap<String, String>(this.options);
        optionsWithSecret.put("value", secretIdentifier);
        ParameterSet parameters = AzureVaultURLParser.PARAMETER_SET_PARSER.parseNamedValues(optionsWithSecret);
        String secretContent = ((KeyVaultSecret)KeyVaultSecretFactory.getInstance().request(parameters).getContent()).getValue();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(secretContent.getBytes());
        return inputStream;
    }

    public String getType() {
        return "azurevault";
    }
}

